/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.foci;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.client.TooltipUtils;
import alexthw.ars_elemental.common.items.Debugger;
import alexthw.ars_elemental.common.items.ElementalCurio;
import alexthw.ars_elemental.common.items.foci.GreaterElementalFocus;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.sauce.api.item.ISchoolFocus;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@EventBusSubscriber(modid="ars_nouveau")
public class ElementalFocus
extends ElementalCurio
implements ISchoolFocus {
    protected SpellSchool element;

    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.LesserFocusDiscount.get();
    }

    public ElementalFocus(Item.Properties properties, SpellSchool element) {
        super(properties);
        this.element = element;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        ServerPlayer player;
        Player player2 = pContext.getPlayer();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getUUID().equals(ArsElemental.Dev) && player.isCrouching()) {
            pContext.getLevel().addFreshEntity((Entity)new ItemEntity(pContext.getLevel(), player.getX(), player.getY(), player.getZ(), ((Debugger)((Object)ModItems.DEBUG_ICON.get())).getDefaultInstance()));
        }
        return super.useOn(pContext);
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (SpellSchools.ELEMENTAL.isPartOfSchool(spellPart)) {
            if (this.element.isPartOfSchool(spellPart)) {
                builder.addAmplification(this.getBoostMultiplier());
            } else {
                builder.addAmplification(this.getMalusMultiplier());
            }
        }
        return builder;
    }

    public SpellSchool getSchool() {
        return this.element;
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return stack.getItem() instanceof ElementalFocus && ((ElementalFocus)stack.getItem()).element == SpellSchools.ELEMENTAL_AIR;
    }

    double getBoostMultiplier() {
        return switch (this.element.getId()) {
            case "fire" -> (Double)ConfigHandler.COMMON.FireMasteryBuff.get();
            case "water" -> (Double)ConfigHandler.COMMON.WaterMasteryBuff.get();
            case "air" -> (Double)ConfigHandler.COMMON.AirMasteryBuff.get();
            case "earth" -> (Double)ConfigHandler.COMMON.EarthMasteryBuff.get();
            default -> 0.0;
        };
    }

    double getMalusMultiplier() {
        return switch (this.element.getId()) {
            case "fire" -> (Double)ConfigHandler.COMMON.FireMasteryDebuff.get();
            case "water" -> (Double)ConfigHandler.COMMON.WaterMasteryDebuff.get();
            case "air" -> (Double)ConfigHandler.COMMON.AirMasteryDebuff.get();
            case "earth" -> (Double)ConfigHandler.COMMON.EarthMasteryDebuff.get();
            default -> 0.0;
        };
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return switch (this.element.getId()) {
            case "fire" -> new ICurio.SoundInfo(SoundEvents.FIRE_AMBIENT, 1.0f, 1.0f);
            case "water" -> new ICurio.SoundInfo(SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, 1.0f, 1.0f);
            case "earth" -> new ICurio.SoundInfo(SoundEvents.ROOTED_DIRT_BREAK, 1.0f, 1.0f);
            case "air" -> new ICurio.SoundInfo(SoundEvents.LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
            default -> super.getEquipSound(slotContext, stack);
        };
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_elemental.focus_element"));
        TooltipUtils.addOnShift(pTooltipComponents, () -> {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_elemental.focus_boost", (Object[])new Object[]{this.element.getTextComponent()}));
            pTooltipComponents.add((Component)Component.translatable((String)(this instanceof GreaterElementalFocus ? "tooltip.ars_elemental.focus_element_mana." + this.element.getId() : "tooltip.ars_elemental.focus_malus")));
        }, "focus");
    }
}

