/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.processors.crush;

import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.processors.Processor;
import dev.qther.ars_unification.recipe.RecipeWrapper;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.jetbrains.annotations.Nullable;

public class IntegratedDynamicsSqueezerProcessor
extends Processor<CraftingInput, RecipeSqueezer> {
    public IntegratedDynamicsSqueezerProcessor(MinecraftServer server) {
        super(server, (Boolean)Config.CONFIG.INTEGRATEDDYNAMICS_USE_MECHANICAL.get() != false ? (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get() : (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get());
    }

    @Override
    public Set<Item> getExistingInputs() {
        return ArsUnification.crushRecipesIngredientSet(this.recipeManager());
    }

    @Override
    @Nullable
    public Ingredient getIngredient(RecipeSqueezer recipe) {
        if (recipe.getOutputFluid().isPresent()) {
            return null;
        }
        Ingredient ingredient = recipe.getInputIngredient();
        if (ingredient.isEmpty()) {
            return null;
        }
        return ingredient;
    }

    @Override
    @Nullable
    public RecipeHolder<?> processCommon(Set<Item> existing, RecipeHolder<? extends RecipeSqueezer> recipeHolder, Ingredient ingredient) {
        RecipeWrapper.Crush wrapper = new RecipeWrapper.Crush(recipeHolder.id(), ingredient);
        for (RecipeSqueezer.IngredientChance output : ((RecipeSqueezer)recipeHolder.value()).getOutputItems()) {
            wrapper = wrapper.withItems(output.getIngredientFirst(), output.getChance());
        }
        return wrapper.asHolder();
    }
}

