/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_unification.recipe;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.qther.ars_unification.ArsUnification;
import dev.qther.ars_unification.Config;
import dev.qther.ars_unification.compat.AUArsTechnicaCompat;
import dev.qther.ars_unification.setup.registry.AURecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public record PressRecipe(Ingredient input, List<PressOutput> outputs, boolean skipBlockPlace) implements SpecialSingleInputRecipe
{
    public PressRecipe(Ingredient input, List<PressOutput> outputs) {
        this(input, outputs, false);
    }

    public List<ItemStack> getRolledOutputs(SpellResolver resolver, SpellStats spellStats, RandomSource random) {
        ArrayList<ItemStack> finalOutputs = new ArrayList<ItemStack>();
        for (PressOutput pressRoll : this.outputs) {
            boolean doubleFromTechnica;
            boolean bl = doubleFromTechnica = (double)pressRoll.chance < 1.0 && ModList.get().isLoaded("ars_technica") && (Boolean)Config.CONFIG.ARS_TECHNICA_TRANSMUTATION_FOCUS_PRESS_CHANCE_OUTPUT_DOUBLING.get() != false && AUArsTechnicaCompat.shouldDoubleOutputs(resolver);
            if (!(random.nextDouble() <= (double)pressRoll.chance)) continue;
            int num = pressRoll.maxRange > 1 ? random.nextInt(pressRoll.maxRange) + 1 : 1;
            for (int i = 0; i < num; ++i) {
                if (doubleFromTechnica) {
                    finalOutputs.add(pressRoll.stack.copyWithCount(Math.min(pressRoll.stack.getMaxStackSize(), pressRoll.stack.getCount() * 2)));
                    continue;
                }
                finalOutputs.add(pressRoll.stack.copy());
            }
        }
        return finalOutputs;
    }

    public boolean shouldSkipBlockPlace() {
        return this.skipBlockPlace;
    }

    public boolean matches(SingleRecipeInput input, @NotNull Level level) {
        return this.input.test(input.getItem(0));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AURecipeRegistry.PRESS_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)AURecipeRegistry.PRESS_TYPE.get();
    }

    public record PressOutput(ItemStack stack, float chance, int maxRange) {
        public static final Codec<PressOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(PressOutput::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(PressOutput::chance), (App)Codec.INT.fieldOf("maxRange").forGetter(PressOutput::maxRange)).apply((Applicative)instance, PressOutput::new));

        public PressOutput(ItemStack stack, float chance) {
            this(stack, chance, 1);
        }
    }

    public static class Serializer
    implements RecipeSerializer<PressRecipe> {
        public static final MapCodec<PressRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(PressRecipe::input), (App)PressOutput.CODEC.listOf().fieldOf("output").forGetter(PressRecipe::outputs), (App)Codec.BOOL.optionalFieldOf("skip_block_place", (Object)false).forGetter(PressRecipe::shouldSkipBlockPlace)).apply((Applicative)instance, PressRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PressRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buf, PressRecipe recipe) {
            buf.writeInt(recipe.outputs.size());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.input);
            for (PressOutput i : recipe.outputs) {
                buf.writeFloat(i.chance);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)i.stack);
                buf.writeInt(i.maxRange);
            }
            buf.writeBoolean(recipe.skipBlockPlace);
        }

        public static PressRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ArrayList<PressOutput> stacks = new ArrayList<PressOutput>();
            for (int i = 0; i < length; ++i) {
                try {
                    float chance = buffer.readFloat();
                    ItemStack outStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                    int maxRange = buffer.readInt();
                    stacks.add(new PressOutput(outStack, chance, maxRange));
                    continue;
                }
                catch (Exception e) {
                    ArsUnification.LOGGER.error("could not deserialize recipe from network", (Throwable)e);
                    break;
                }
            }
            boolean skipBlockPlace = buffer.readBoolean();
            return new PressRecipe(input, stacks, skipBlockPlace);
        }

        @NotNull
        public MapCodec<PressRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, PressRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

