/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.crops;

import com.mojang.serialization.MapCodec;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class PowderyCannonBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<PowderyCannonBlock> CODEC = PowderyCannonBlock.simpleCodec(PowderyCannonBlock::new);
    protected static final VoxelShape SMALL_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<BambooLeaves> LEAVES = BlockStateProperties.BAMBOO_LEAVES;
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty PRESSURE = IntegerProperty.create((String)"pressure", (int)0, (int)2);

    public MapCodec<PowderyCannonBlock> codec() {
        return CODEC;
    }

    public PowderyCannonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)PRESSURE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)MNDItems.POWDER_CANNON.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, LEAVES, STAGE, LIT, PRESSURE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelshape = state.getValue(LEAVES) == BambooLeaves.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3 vec3 = state.getOffset(level, pos);
        return voxelshape.move(vec3.x, vec3.y, vec3.z);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return COLLISION_SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (!fluidstate.isEmpty()) {
            return null;
        }
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().below());
        TriState soilDecision = blockstate.canSustainPlant((BlockGetter)context.getLevel(), context.getClickedPos().below(), Direction.UP, this.defaultBlockState());
        if (soilDecision.isDefault() ? !blockstate.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON) : !soilDecision.isTrue()) {
            return null;
        }
        if (blockstate.is(MNDBlocks.POWDERY_CHUBBY_SAPLING.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0));
        }
        if (blockstate.is(MNDBlocks.POWDERY_CANNON.get())) {
            int i = (Integer)blockstate.getValue((Property)AGE) > 0 ? 1 : 0;
            return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i));
        }
        BlockState blockstate1 = context.getLevel().getBlockState(context.getClickedPos().above());
        return blockstate1.is(MNDBlocks.POWDERY_CANNON.get()) ? (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)blockstate1.getValue((Property)AGE))) : MNDBlocks.POWDERY_CHUBBY_SAPLING.get().defaultBlockState();
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        int pressure = (Integer)state.getValue((Property)PRESSURE);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (!state.canSurvive((LevelReader)level, pos)) {
            if (isLit) {
                this.explodeAndReset((Level)level, pos, state);
            }
            level.destroyBlock(pos, true);
        }
        if (pressure > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure - 1)), 2);
        }
        if (stateAbove.hasProperty((Property)PRESSURE) && (Integer)stateAbove.getValue((Property)PRESSURE) < 2 && (stateAbove.is(MNDTags.POWDERY_CANE) || stateAbove.is(MNDBlocks.BULLET_PEPPER.get()))) {
            level.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)stateAbove.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (pressure == 2 && isLit) {
            this.explodeAndReset((Level)level, pos, state);
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)STAGE) == 0 || state.getValue(LEAVES) != BambooLeaves.NONE && (Boolean)state.getValue((Property)LIT) == false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean hasLeaves;
        if (world.isClientSide) {
            return;
        }
        BlockPos posAbove = pos.above();
        BlockState stateAbove = world.getBlockState(posAbove);
        int maxHeight = world.dimension() == Level.NETHER ? 8 : 16;
        int height = this.getHeightBelowUpToMax((BlockGetter)world, pos) + 1;
        boolean canGrow = (Integer)state.getValue((Property)STAGE) == 0 && world.isEmptyBlock(posAbove);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        boolean bl = hasLeaves = state.getValue(LEAVES) != BambooLeaves.NONE;
        if (canGrow && height < maxHeight && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.growCannon(state, (Level)world, pos, random, height);
            CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (!isLit && hasLeaves) {
            if ((height == maxHeight || (Integer)state.getValue((Property)STAGE) > 0) && world.isEmptyBlock(posAbove)) {
                world.setBlock(posAbove, MNDBlocks.BULLET_PEPPER.get().defaultBlockState(), 3);
            }
            if (random.nextInt(world.dimension() == Level.NETHER ? 300 : 900) == 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
                world.playSound(null, pos, (SoundEvent)SoundEvents.CROSSBOW_LOADING_MIDDLE.value(), SoundSource.BLOCKS, 0.5f, 0.25f);
            }
        } else if (isLit && stateAbove.is(MNDBlocks.POWDERY_CANNON.get()) && !((Boolean)stateAbove.getValue((Property)LIT)).booleanValue()) {
            if ((height >= maxHeight - 2 || (Integer)stateAbove.getValue((Property)STAGE) > 0) && world.isEmptyBlock(posAbove.above())) {
                world.setBlock(posAbove.above(), MNDBlocks.BULLET_PEPPER.get().defaultBlockState(), 3);
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            world.playSound(null, pos, (SoundEvent)SoundEvents.CROSSBOW_LOADING_MIDDLE.value(), SoundSource.BLOCKS, 0.5f, 0.25f);
            world.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soilDecision = level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        return !soilDecision.isDefault() ? soilDecision.isTrue() : level.getBlockState(pos.below()).is(MNDTags.POWDERY_CANNON_PLANTABLE_ON);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                this.explodeAndReset((Level)level, pos, state);
            }
            level.destroyBlock(pos, true);
        }
        if ((Integer)state.getValue((Property)PRESSURE) > 0) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && offsetState.is(MNDBlocks.POWDERY_CANNON.get()) && (Integer)offsetState.getValue((Property)AGE) > (Integer)state.getValue((Property)AGE)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
        }
        if (state.getValue(LEAVES) == BambooLeaves.NONE) {
            return (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockState stateAbove = level.getBlockState(pos.above());
        if (!stateAbove.isAir() && stateAbove.hasProperty((Property)BlockStateProperties.STAGE)) {
            int stage = (Integer)stateAbove.getValue((Property)BlockStateProperties.STAGE);
            return stage < 1;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = this.getHeightAboveUpToMax((BlockGetter)level, pos);
        int j = this.getHeightBelowUpToMax((BlockGetter)level, pos);
        int k = i + j + 1;
        int l = 1 + random.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.above(i);
            BlockState blockstate = level.getBlockState(blockpos);
            if (k >= 16 || (Integer)blockstate.getValue((Property)STAGE) == 1 || !level.isEmptyBlock(blockpos.above())) {
                return;
            }
            this.growCannon(blockstate, (Level)level, blockpos, random, k);
            ++i;
            ++k;
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        int pressure = (Integer)state.getValue((Property)PRESSURE);
        if (entity instanceof LivingEntity && entity.getType() != EntityType.PANDA && entity.getType() != EntityType.BEE && !((LivingEntity)entity).isCrouching()) {
            entity.hurt(level.damageSources().cactus(), 1.0f);
            entity.makeStuckInBlock(state, new Vec3(0.8, 0.75, 0.8));
            if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2) {
                level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure + 1)), 2);
            }
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        int pressure = (Integer)state.getValue((Property)PRESSURE);
        if (entity instanceof LivingEntity && entity.getType() != EntityType.PANDA && entity.getType() != EntityType.BEE && !((LivingEntity)entity).isCrouching()) {
            entity.hurt(level.damageSources().cactus(), 1.0f);
            entity.makeStuckInBlock(state, new Vec3(0.8, 0.75, 0.8));
            if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2) {
                level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure + 1)), 2);
            }
        }
    }

    private void explodeAndReset(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide && state.hasProperty((Property)LIT) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.playSound(null, pos, SoundEvents.CREEPER_PRIMED, SoundSource.BLOCKS, 0.5f, 0.25f);
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected void growCannon(BlockState state, Level level, BlockPos pos, RandomSource random, int height) {
        int maxHeight;
        BlockState blockstate = level.getBlockState(pos.below());
        BlockPos blockpos = pos.below(2);
        BlockState blockstate1 = level.getBlockState(blockpos);
        BambooLeaves leaves = BambooLeaves.NONE;
        int n = maxHeight = level.dimension() == Level.NETHER ? 8 : 16;
        if (height >= 1) {
            if (blockstate.is(MNDBlocks.POWDERY_CANNON.get()) && blockstate.getValue(LEAVES) != BambooLeaves.NONE) {
                if (blockstate.is(MNDBlocks.POWDERY_CANNON.get()) && blockstate.getValue(LEAVES) != BambooLeaves.NONE) {
                    leaves = BambooLeaves.LARGE;
                    if (blockstate1.is(MNDBlocks.POWDERY_CANNON.get())) {
                        level.setBlock(pos.below(), (BlockState)blockstate.setValue(LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                        level.setBlock(blockpos, (BlockState)blockstate1.setValue(LEAVES, (Comparable)BambooLeaves.NONE), 3);
                    }
                }
            } else {
                leaves = BambooLeaves.SMALL;
            }
        }
        int i = (Integer)state.getValue((Property)AGE) != 1 && !blockstate1.is(MNDBlocks.POWDERY_CANNON.get()) ? 0 : 1;
        int MH = 1 + level.random.nextInt(3);
        int j = !(height >= maxHeight && random.nextFloat() < 0.25f || height == maxHeight - MH) ? 0 : 1;
        level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue(LEAVES, (Comparable)leaves)).setValue((Property)STAGE, (Comparable)Integer.valueOf(j)), 3);
        if ((height >= maxHeight - MH || height == maxHeight) && level.isEmptyBlock(pos.above(2))) {
            level.setBlock(pos.above(2), MNDBlocks.BULLET_PEPPER.get().defaultBlockState(), 3);
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        int maxHeight = level instanceof Level && ((Level)level).dimension() == Level.NETHER ? 8 : 16;
        for (i = 0; i < maxHeight && level.getBlockState(pos.above(i + 1)).is(MNDBlocks.POWDERY_CANNON.get()); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter level, BlockPos pos) {
        int i;
        int maxHeight = level instanceof Level && ((Level)level).dimension() == Level.NETHER ? 8 : 16;
        for (i = 0; i < maxHeight && level.getBlockState(pos.below(i + 1)).is(MNDBlocks.POWDERY_CANNON.get()); ++i) {
        }
        return i;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack heldItem;
        if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2 && !player.isCrouching()) {
            int pressure = (Integer)state.getValue((Property)PRESSURE);
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure + 1)), 2);
        }
        if (!(!((Boolean)state.getValue((Property)LIT)).booleanValue() || (heldItem = player.getItemInHand(InteractionHand.MAIN_HAND)).is(CommonTags.TOOLS_KNIFE) && heldItem.is(Tags.Items.TOOLS_SHEAR))) {
            this.explodeAndReset(level, pos, state);
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem;
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && ((heldItem = player.getItemInHand(hand)).is(CommonTags.TOOLS_KNIFE) || heldItem.is(Tags.Items.TOOLS_SHEAR))) {
            heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            int j = 3 + level.random.nextInt(6);
            PowderyCannonBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get(), j));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.FALSE), 3);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            this.explodeAndReset(level, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }
}

