/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.effect;

import com.soytutta.mynethersdelight.common.registry.MNDEffects;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractPungentEffect
extends MobEffect {
    public AbstractPungentEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    private boolean hasFireProtectionArmor(LivingEntity entity) {
        Registry enchantmentRegistry = entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional fireProtectionHolderOpt = enchantmentRegistry.getHolder(Enchantments.FIRE_PROTECTION);
        if (fireProtectionHolderOpt.isEmpty()) {
            return false;
        }
        Holder fireProtectionHolder = (Holder)fireProtectionHolderOpt.get();
        for (ItemStack armorPiece : entity.getArmorSlots()) {
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)fireProtectionHolder, (ItemStack)armorPiece) <= 0) continue;
            return true;
        }
        return false;
    }

    protected void switchEffect(LivingEntity entity) {
        MobEffect targetEffect;
        boolean isImmuneToFire = entity.fireImmune() || entity.hasEffect(MobEffects.FIRE_RESISTANCE) || this.hasFireProtectionArmor(entity);
        Holder thisHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this);
        MobEffectInstance currentEffectInstance = entity.getEffect(thisHolder);
        if (currentEffectInstance == null) {
            return;
        }
        MobEffect mobEffect = targetEffect = isImmuneToFire ? (MobEffect)MNDEffects.GPUNGENT.value() : (MobEffect)MNDEffects.BPUNGENT.value();
        if (this != targetEffect) {
            this.transformEffect(entity, currentEffectInstance, targetEffect);
        }
    }

    private void transformEffect(LivingEntity entity, MobEffectInstance oldEffect, MobEffect newEffect) {
        Holder newEffectHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)newEffect);
        int duration = oldEffect.getDuration();
        int amplifier = oldEffect.getAmplifier();
        boolean ambient = oldEffect.isAmbient();
        boolean visible = oldEffect.isVisible();
        boolean icon = oldEffect.showIcon();
        entity.removeEffect(oldEffect.getEffect());
        entity.addEffect(new MobEffectInstance(newEffectHolder, duration, amplifier, ambient, visible, icon));
    }

    protected boolean isInFireCondition(LivingEntity entity) {
        Level world = entity.level();
        BlockPos entityPos = entity.blockPosition();
        int areaSize = 1;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)entityPos.offset(-areaSize, -areaSize, -areaSize), (BlockPos)entityPos.offset(areaSize, areaSize, areaSize))) {
            BlockState blockState = world.getBlockState(pos);
            if (!blockState.is(MNDTags.LETIOS_FLAMES) || blockState.hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

