/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.effect;

import com.soytutta.mynethersdelight.common.effect.AbstractPungentEffect;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class GoodPungentEffect
extends AbstractPungentEffect {
    public GoodPungentEffect() {
        super(MobEffectCategory.BENEFICIAL, 16766720);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        this.switchEffect(entity);
        if (this.isInFireCondition(entity) || entity.isInLava() || entity.isOnFire()) {
            if (entity.getHealth() < entity.getMaxHealth()) {
                entity.heal(2.0f);
                if (!entity.level().isClientSide) {
                    Random random = new Random();
                    double width = entity.getBbWidth();
                    double height = entity.getBbHeight();
                    int i = 0;
                    while ((double)i < 0.5) {
                        double x = entity.getX() + (random.nextDouble() - 0.5) * width;
                        double y = entity.getY() + random.nextDouble() * height;
                        double z = entity.getZ() + (random.nextDouble() - 0.5) * width;
                        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                        ++i;
                    }
                }
            } else {
                entity.setRemainingFireTicks(0);
                entity.clearFire();
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 40 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

