/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.menu;

import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WarpNexusMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;

    public WarpNexusMenu(int containerId, Inventory playerInv, ContainerLevelAccess access, ItemStackHandler inventory) {
        super(MenuType.GENERIC_3x3, containerId);
        this.access = access;
        this.createWarpNexusInventory(inventory);
        this.createPlayerInventory(playerInv);
        this.createPlayerHotbar(playerInv);
    }

    private void createWarpNexusInventory(ItemStackHandler handler) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)handler, column + row * 3, 62 + column * 18, 17 + row * 18){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        boolean isWarpScroll;
                        boolean bl = isWarpScroll = stack.is((Item)ItemsRegistry.WARP_SCROLL.get()) || stack.is((Item)ItemsRegistry.STABLE_WARP_SCROLL.get()) || stack.is((Item)AddonItemRegistry.NEXUS_WARP_SCROLL.get());
                        if (!isWarpScroll) {
                            return false;
                        }
                        WarpScrollData data = (WarpScrollData)stack.getOrDefault((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true));
                        return data.isValid();
                    }
                });
            }
        }
    }

    private void createPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInv, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
    }

    private void createPlayerHotbar(Inventory playerInv) {
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInv, column, 8 + column * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return itemStack;
        }
        ItemStack item = slot.getItem();
        itemStack = item.copy();
        if (index < 9 ? !this.moveItemStackTo(item, 9, 45, true) : !this.moveItemStackTo(item, 0, 9, false)) {
            return ItemStack.EMPTY;
        }
        if (item.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (item.getCount() == itemStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, item);
        return itemStack;
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
    }

    public boolean stillValid(Player player) {
        return WarpNexusMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)AddonBlockRegistry.WARP_NEXUS.get()));
    }
}

