/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.worldgen;

import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.items.data.StarbuncleCharmData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendStatic;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class ProcessorDatagen
extends SimpleDataProvider {
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public ProcessorDatagen(DataGenerator dataGenerator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(dataGenerator);
        this.lookupProvider = lookupProvider;
    }

    public void collectJsons(CachedOutput pOutput) {
        ArrayList<ProcessorRule> nexusTower = new ArrayList<ProcessorRule>();
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.MOSSY_STONE_BRICKS, 0.5f));
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, 0.5f));
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.STONE, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.ANDESITE, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.TUFF, 0.1f));
        nexusTower.add(this.randomBlockReplace(Blocks.STONE_BRICKS, Blocks.COBBLESTONE, 0.1f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.aa("cracked_sourcestone_large_bricks"), 0.5f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("gilded_sourcestone_large_bricks"), 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), Blocks.BLUE_TERRACOTTA, 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("sourcestone_alternating"), 0.2f));
        nexusTower.add(this.randomBlockStateReplace((BlockState)Blocks.STONE_BRICK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), (BlockState)Blocks.MOSSY_STONE_BRICK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP), 0.2f));
        nexusTower.add(this.randomBlockStateReplace((BlockState)Blocks.STONE_BRICK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM), (BlockState)Blocks.MOSSY_STONE_BRICK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM), 0.2f));
        nexusTower.add(this.randomBlockReplace(this.an("sourcestone_large_bricks"), this.an("sourcestone_alternating"), 0.2f));
        this.setupWarpNexus(nexusTower);
        List<Helper> helpers = List.of(new Helper("Eru", "gray", "Warning: Not to leave unsupervised"), new Helper("Rozeta", "pink", "A curious Starbuncle that likes to build and experiment with magic."), new Helper("Pug", "green", "A Starbuncle that sells the magic it salvages."));
        HashMap<String, Integer> dyeMap = new HashMap<String, Integer>();
        for (DyeColor value : DyeColor.values()) {
            dyeMap.put(value.getName(), value.getTextColor());
        }
        ((CompletableFuture)this.lookupProvider.thenAccept(provider -> {
            for (Helper helper : helpers) {
                CompoundTag tag = new CompoundTag();
                ItemStack is = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_CHARM);
                is.set((Supplier)DataComponentRegistry.STARBUNCLE_DATA, (Object)new StarbuncleCharmData(Optional.of(Component.literal((String)helper.name()).withStyle(Style.EMPTY.withColor(((Integer)dyeMap.get(helper.color())).intValue()))), helper.color(), Optional.empty(), Optional.empty(), StarbyTransportBehavior.TRANSPORT_ID, new CompoundTag(), "", helper.bio()));
                tag.put("itemStack", is.save(provider));
                this.modifyBlockEntity((Block)BlockRegistry.SCRIBES_BLOCK.get(), (BlockState bs) -> bs.getValue((Property)ScribesBlock.PART) == ThreePartBlock.HEAD, 0.5f, (RuleBlockEntityModifier)new AppendStatic(tag), (List<ProcessorRule>)nexusTower);
            }
        })).join();
        this.save(pOutput, nexusTower, "nexus_tower");
        ArrayList<ProcessorRule> arcaneLibrary = new ArrayList<ProcessorRule>();
        this.chargeRunes(arcaneLibrary);
        this.setupWarpNexus(arcaneLibrary);
        this.setupSourceJars(arcaneLibrary);
        this.save(pOutput, arcaneLibrary, "arcane_library");
    }

    private void setupSourceJars(List<ProcessorRule> rules) {
        for (Integer possibleValue : SourceJar.fill.getPossibleValues()) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("source", Math.max((possibleValue - 1) * 1000, 0));
            this.modifyBlockEntity((Block)BlockRegistry.SOURCE_JAR.get(), (BlockState bs) -> true, bs -> (BlockState)bs.setValue(SourceJar.fill, (Comparable)possibleValue), (RuleBlockEntityModifier)new AppendStatic(tag), rules);
        }
    }

    private void setupWarpNexus(List<ProcessorRule> rules) {
        CompoundTag nexusBlock = new CompoundTag();
        ItemStack stack = new ItemStack((ItemLike)AddonItemRegistry.NEXUS_WARP_SCROLL.get());
        ((CompletableFuture)this.lookupProvider.thenAccept(provider -> nexusBlock.put("itemStack", stack.save(provider)))).join();
        this.modifyBlockEntity((Block)AddonBlockRegistry.WARP_NEXUS.get(), (BlockState bs) -> bs.getValue(WarpNexus.HALF) == DoubleBlockHalf.LOWER, bs -> (BlockState)bs.setValue((Property)WarpNexus.REQUIRES_SOURCE, (Comparable)Boolean.valueOf(false)), (RuleBlockEntityModifier)new AppendStatic(nexusBlock), rules);
        this.modifyBlockEntity((Block)AddonBlockRegistry.WARP_NEXUS.get(), (BlockState bs) -> bs.getValue(WarpNexus.HALF) == DoubleBlockHalf.UPPER, bs -> (BlockState)bs.setValue((Property)WarpNexus.REQUIRES_SOURCE, (Comparable)Boolean.valueOf(false)), (RuleBlockEntityModifier)new AppendStatic(new CompoundTag()), rules);
    }

    private void chargeRunes(List<ProcessorRule> rules) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("charged", true);
        tag.putBoolean("temporary", false);
        tag.putUUID("uuid", ANFakePlayer.PROFILE.getId());
        this.modifyBlockEntity((Block)BlockRegistry.RUNE_BLOCK.get(), bs -> (Boolean)bs.getValue((Property)RuneBlock.POWERED) == false, bs -> (BlockState)bs.setValue((Property)RuneBlock.POWERED, (Comparable)Boolean.valueOf(true)), Float.valueOf(1.0f), (RuleBlockEntityModifier)new AppendStatic(tag), rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, Function<BlockState, BlockState> output, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        this.modifyBlockEntity(block, filter, output, null, modifier, rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, float probability, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        this.modifyBlockEntity(block, filter, bs -> bs, Float.valueOf(probability), modifier, rules);
    }

    private void modifyBlockEntity(Block block, Predicate<BlockState> filter, Function<BlockState, BlockState> output, Float probability, RuleBlockEntityModifier modifier, List<ProcessorRule> rules) {
        for (BlockState possibleState : block.getStateDefinition().getPossibleStates()) {
            if (!filter.test(possibleState)) continue;
            RandomBlockStateMatchTest test = probability != null ? new RandomBlockStateMatchTest(possibleState, probability.floatValue()) : new BlockStateMatchTest(possibleState);
            rules.add(new ProcessorRule((RuleTest)test, (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, output.apply(possibleState), modifier));
        }
    }

    private void save(CachedOutput pOutput, List<ProcessorRule> rules, String name) {
        StructureProcessorList list = new StructureProcessorList((List)ImmutableList.of((Object)new RuleProcessor(rules)));
        DataResult result = StructureProcessorType.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)list);
        result.result().ifPresent(element -> this.saveStable(pOutput, (JsonElement)element, this.getPath(name)));
    }

    private Path getPath(String name) {
        return this.output.resolve("data/ars_additions/worldgen/processor_list/" + name + ".json");
    }

    private Block aa(String name) {
        return AddonBlockRegistry.getBlock(name);
    }

    private Block an(String name) {
        return BlockRegistry.getBlock((String)name);
    }

    private ProcessorRule randomBlockStateReplace(BlockState input, Block output, float probability) {
        return this.randomBlockStateReplace(input, output.defaultBlockState(), probability);
    }

    private ProcessorRule randomBlockStateReplace(BlockState input, BlockState output, float probability) {
        return new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(input, probability), (RuleTest)AlwaysTrueTest.INSTANCE, output);
    }

    private ProcessorRule randomBlockReplace(Block input, Block output, float probability) {
        return this.randomBlockReplace(input, output.defaultBlockState(), probability);
    }

    private ProcessorRule randomBlockReplace(Block input, BlockState output, float probability) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(input, probability), (RuleTest)AlwaysTrueTest.INSTANCE, output);
    }

    public String getName() {
        return "Processor Lists";
    }

    record Helper(String name, String color, String bio) {
    }
}

