/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.block.entity.spawner.BossSpawnerBlockEntity;
import twilightforest.enums.BossVariant;

public class BossSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<BossSpawnerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BossVariant.CODEC.fieldOf("variant").forGetter(o -> o.boss), (App)BossSpawnerBlock.propertiesCodec()).apply((Applicative)instance, BossSpawnerBlock::new));
    private final BossVariant boss;

    public BossSpawnerBlock(BossVariant variant, BlockBehaviour.Properties properties) {
        super(properties);
        this.boss = variant;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.boss.getType().create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BossSpawnerBlock.createTickerHelper(type, this.boss.getType(), BossSpawnerBlockEntity::tick);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }
}

