/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.event;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.init.TFBiomes;

public class FogHandler {
    private static boolean SKY_CHUNK_LOADED = false;
    private static float SKY_FAR = 0.0f;
    private static float SKY_NEAR = 0.0f;
    private static boolean TERRAIN_CHUNK_LOADED = false;
    private static float TERRAIN_FAR = 0.0f;
    private static float TERRAIN_NEAR = 0.0f;

    protected static void renderFog(ViewportEvent.RenderFog event) {
        ClientLevel clientLevel;
        LocalPlayer player;
        Entity entity;
        if (event.getType().equals((Object)FogType.NONE) && (entity = Minecraft.getInstance().cameraEntity) instanceof LocalPlayer && (entity = (player = (LocalPlayer)entity).level()) instanceof ClientLevel && (clientLevel = (ClientLevel)entity).effects() instanceof TwilightForestRenderInfo) {
            if (event.getMode().equals((Object)FogRenderer.FogMode.FOG_SKY)) {
                if (SKY_CHUNK_LOADED) {
                    event.setCanceled(true);
                    boolean spooky = FogHandler.isSpooky(clientLevel, player);
                    float far = spooky ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                    float near = spooky ? 0.0f : event.getNearPlaneDistance();
                    SKY_FAR = Mth.lerp((float)0.003f, (float)SKY_FAR, (float)far);
                    SKY_NEAR = Mth.lerp((float)(0.003f * (SKY_NEAR < near ? 0.5f : 2.0f)), (float)SKY_NEAR, (float)near);
                    event.setFarPlaneDistance(SKY_FAR);
                    event.setNearPlaneDistance(SKY_NEAR);
                } else if (clientLevel.isLoaded(player.blockPosition())) {
                    SKY_CHUNK_LOADED = true;
                    SKY_FAR = FogHandler.isSpooky(clientLevel, player) ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                    SKY_NEAR = FogHandler.isSpooky(clientLevel, player) ? 0.0f : event.getNearPlaneDistance();
                }
            } else if (TERRAIN_CHUNK_LOADED) {
                event.setCanceled(true);
                boolean spooky = FogHandler.isSpooky(clientLevel, player);
                float far = spooky ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                float near = spooky ? far * 0.75f : event.getNearPlaneDistance();
                TERRAIN_FAR = Mth.lerp((float)0.003f, (float)TERRAIN_FAR, (float)far);
                TERRAIN_NEAR = Mth.lerp((float)(0.003f * (TERRAIN_NEAR < near ? 0.5f : 2.0f)), (float)TERRAIN_NEAR, (float)near);
                event.setFarPlaneDistance(TERRAIN_FAR);
                event.setNearPlaneDistance(TERRAIN_NEAR);
            } else if (SKY_CHUNK_LOADED || clientLevel.isLoaded(player.blockPosition())) {
                TERRAIN_CHUNK_LOADED = true;
                TERRAIN_FAR = FogHandler.isSpooky(clientLevel, player) ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                TERRAIN_NEAR = FogHandler.isSpooky(clientLevel, player) ? TERRAIN_FAR * 0.75f : event.getNearPlaneDistance();
            }
        }
    }

    protected static void unloadFog(LevelEvent.Unload event) {
        SKY_CHUNK_LOADED = false;
        TERRAIN_CHUNK_LOADED = false;
    }

    private static boolean isSpooky(@Nullable ClientLevel level, @Nullable LocalPlayer player) {
        return level != null && player != null && level.getBiome(player.blockPosition()).is(TFBiomes.SPOOKY_FOREST);
    }
}

