/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.MinoshroomRenderer;
import twilightforest.entity.boss.Minoshroom;

public class MinoshroomModel<T extends Minoshroom>
extends HumanoidModel<T>
implements TrophyBlockModel {
    public final ModelPart cowTorso;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightBackLeg;
    private final ModelPart leftBackLeg;

    public MinoshroomModel(ModelPart root) {
        super(root);
        this.cowTorso = root.getChild("cow_torso");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightBackLeg = root.getChild("right_back_leg");
        this.leftBackLeg = root.getChild("left_back_leg");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? MinoshroomModel.createJappaModel() : MinoshroomModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(96, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(105, 28).addBox(-2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition rightHorn = head.addOrReplaceChild("right_horn_1", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-5.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.43633232f, (float)0.17453292f));
        rightHorn.addOrReplaceChild("right_horn_2", CubeListBuilder.create().mirror().texOffs(16, 0).addBox(-3.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.7853982f));
        PartDefinition leftHorn = head.addOrReplaceChild("left_horn_1", CubeListBuilder.create().texOffs(0, 0).addBox(0.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)0.43633232f, (float)-0.17453292f));
        leftHorn.addOrReplaceChild("left_horn_2", CubeListBuilder.create().texOffs(16, 0).addBox(0.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)-0.7853982f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, 0.0f, -2.5f, 8.0f, 12.0f, 5.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(90, 0).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)-4.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(90, 0).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)-4.0f, (float)-9.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("cow_torso", CubeListBuilder.create().texOffs(18, 4).addBox(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.570796f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("udders", CubeListBuilder.create().texOffs(53, 1).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -11.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(0, 16).addBox(-3.0f, -6.0f, -5.0f, 6.0f, 3.0f, 1.0f).texOffs(32, 0).addBox(-8.0f, -10.0f, -1.0f, 4.0f, 2.0f, 3.0f).texOffs(32, 5).addBox(-8.0f, -13.0f, -1.0f, 2.0f, 3.0f, 3.0f).texOffs(46, 0).addBox(4.0f, -10.0f, -1.0f, 4.0f, 2.0f, 3.0f).texOffs(46, 5).addBox(6.0f, -13.0f, -1.0f, 2.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, -3.0f, 0.0f, 10.0f, 12.0f, 5.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(46, 15).addBox(0.0f, -1.0f, -2.0f, 4.0f, 14.0f, 5.0f), PartPose.offset((float)5.0f, (float)-8.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(28, 15).addBox(-4.0f, -1.0f, -2.0f, 4.0f, 14.0f, 5.0f), PartPose.offset((float)-5.0f, (float)-8.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("cow_torso", CubeListBuilder.create().texOffs(20, 36).addBox(-6.0f, -14.0f, -2.0f, 12.0f, 18.0f, 10.0f).texOffs(0, 20).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)6.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-4.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)4.0f, (float)12.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.cowTorso, (Object)this.leftBackLeg, (Object)this.rightBackLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag2;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = entity.getMainArm() == HumanoidArm.RIGHT;
        if (entity.isUsingItem()) {
            boolean flag3;
            boolean bl2 = flag3 = entity.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm((LivingEntity)entity);
            } else {
                this.poseLeftArm((LivingEntity)entity);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm((LivingEntity)entity);
                this.poseRightArm((LivingEntity)entity);
            } else {
                this.poseRightArm((LivingEntity)entity);
                this.poseLeftArm((LivingEntity)entity);
            }
        }
        if (this.rightArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        }
        this.cowTorso.xRot = 1.5707964f;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f = ageInTicks - (float)((Minoshroom)entity).tickCount;
        float f1 = ((Minoshroom)entity).getChargeAnimationScale(f);
        f1 *= f1;
        boolean jappa = JappaPackReloadListener.INSTANCE.isJappaPackLoaded();
        this.leftFrontLeg.y = 12.0f + (jappa ? -7.0f : -5.0f) * f1;
        this.leftFrontLeg.z = -4.0f + f1;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        this.head.y = (jappa ? -4.0f : -6.0f) + -3.0f * f1;
        this.head.z = -9.0f + 6.0f * f1;
        this.body.y = (jappa ? -4.0f : -6.0f) + -3.0f * f1;
        this.body.z = (jappa ? -11.0f : -9.0f) + 6.0f * f1;
        this.cowTorso.y = (jappa ? 10.0f : 5.0f) + f1;
        this.cowTorso.z = (jappa ? 6.0f : 2.0f) + (jappa ? 1.0f : 4.0f) * f1;
        this.rightArm.y = (jappa ? -6.0f : -4.0f) - 3.0f * f1;
        this.rightArm.z = -9.0f + 6.0f * f1;
        this.leftArm.y = this.rightArm.y;
        this.leftArm.z = this.rightArm.z;
        if (f1 > 0.0f) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArm.xRot = f1 * -1.8f;
                this.leftArm.xRot = 0.0f;
                this.rightArm.zRot = -0.2f;
            } else {
                this.rightArm.xRot = 0.0f;
                this.leftArm.xRot = f1 * -1.8f;
                this.leftArm.zRot = 0.2f;
            }
            this.cowTorso.xRot = 1.5707964f - f1 * (float)Math.PI * 0.2f;
            this.leftFrontLeg.xRot -= f1 * (float)Math.PI * 0.3f;
            this.rightFrontLeg.xRot -= f1 * (float)Math.PI * 0.3f;
        }
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        if (!JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            stack.translate(0.0f, 0.375f, 0.56f);
        } else {
            stack.translate(0.0f, 0.5625f, 0.4375f);
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)MinoshroomRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
    }
}

