/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import twilightforest.entity.monster.SkeletonDruid;

public class SkeletonDruidModel
extends SkeletonModel<SkeletonDruid> {
    private final ModelPart dress;

    public SkeletonDruidModel(ModelPart root) {
        super(root);
        this.dress = root.getChild("dress");
    }

    public static LayerDefinition create(CubeDeformation deformation) {
        MeshDefinition meshdefinition = SkeletonModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(8, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, deformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, deformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 2.0f, 12.0f, 2.0f, deformation), PartPose.offset((float)3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 2.0f, 12.0f, 2.0f, deformation), PartPose.offset((float)-1.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("dress", CubeListBuilder.create().texOffs(32, 16).addBox(-4.0f, 12.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition create() {
        return SkeletonDruidModel.create(CubeDeformation.NONE);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.dress));
    }
}

