/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.CandelabraBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.entity.CandelabraBlockEntity;

public class CandelabraRenderer<T extends CandelabraBlockEntity>
implements BlockEntityRenderer<T> {
    public CandelabraRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = entity.getBlockState();
        Direction direction = (Direction)state.getValue((Property)CandelabraBlock.FACING);
        for (int i = 0; i < ((CandelabraBlockEntity)((Object)entity)).getCandles().ordered().size(); ++i) {
            stack.pushPose();
            float offset = 0.315f - 0.315f * (float)i;
            if (((Boolean)state.getValue((Property)CandelabraBlock.ON_WALL)).booleanValue()) {
                stack.translate((double)((float)(-Math.abs(direction.getStepZ())) * offset) + (double)direction.getStepX() * 0.25, (double)0.44f, (double)((float)(-Math.abs(direction.getStepX())) * offset) + (double)direction.getStepZ() * 0.25);
            } else {
                stack.translate((float)(-Math.abs(direction.getStepZ())) * offset, 0.44f, (float)(-Math.abs(direction.getStepX())) * offset);
            }
            BlockState candle = ((CandelabraBlockEntity)((Object)entity)).getCandle(i).defaultBlockState();
            if (candle.hasProperty((Property)CandleBlock.LIT)) {
                candle = (BlockState)candle.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(state.getValue((Property)CandelabraBlock.LIGHTING) == LightableBlock.Lighting.NORMAL));
            }
            if (!candle.isAir()) {
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(candle, stack, buffer, light, overlay);
            }
            stack.popPose();
        }
    }
}

