/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.mojang.datafixers.util.Pair;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.registries.DeferredHolder;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFTrappedChestBlock;
import twilightforest.data.StonecuttingGenerator;
import twilightforest.data.custom.NoSmithingTemplateRecipeBuilder;
import twilightforest.data.custom.ScepterRecipeBuilder;
import twilightforest.data.custom.UncraftingGenerator;
import twilightforest.data.helpers.CraftingDataHelper;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFItems;
import twilightforest.item.recipe.CasketRepairRecipe;
import twilightforest.item.recipe.EmperorsClothRecipe;
import twilightforest.item.recipe.EssenceRepairRecipe;
import twilightforest.item.recipe.MagicMapCloningRecipe;
import twilightforest.item.recipe.MazeMapCloningRecipe;
import twilightforest.item.recipe.MoonwormQueenRepairRecipe;
import twilightforest.item.recipe.UncraftingTableCondition;

public class CraftingGenerator
extends CraftingDataHelper {
    private final HolderLookup.Provider provider;

    public CraftingGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
        this.provider = provider.join();
    }

    protected void buildRecipes(RecipeOutput output) {
        StonecuttingGenerator.buildRecipes(output);
        UncraftingGenerator.buildRecipes(output);
        this.blockCompressionRecipes(output);
        this.equipmentRecipes(this.provider, output);
        this.emptyMapRecipes(output);
        this.woodRecipes(output);
        this.fieryConversions(output);
        this.nagastoneRecipes(output);
        this.darkTowerRecipes(output);
        this.castleRecipes(output);
        this.bannerPattern(output, "naga_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.NAGA_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.NAGA_BANNER_PATTERN);
        this.bannerPattern(output, "lich_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.LICH_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.LICH_BANNER_PATTERN);
        this.bannerPattern(output, "minoshroom_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINOSHROOM_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.MINOSHROOM_BANNER_PATTERN);
        this.bannerPattern(output, "hydra_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.HYDRA_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.HYDRA_BANNER_PATTERN);
        this.bannerPattern(output, "knight_phantom_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.KNIGHT_PHANTOM_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHT_PHANTOM_BANNER_PATTERN);
        this.bannerPattern(output, "ur_ghast_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.UR_GHAST_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.UR_GHAST_BANNER_PATTERN);
        this.bannerPattern(output, "alpha_yeti_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.ALPHA_YETI_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.ALPHA_YETI_BANNER_PATTERN);
        this.bannerPattern(output, "snow_queen_banner_pattern", (DeferredHolder<Block, ? extends Block>)TFBlocks.SNOW_QUEEN_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.SNOW_QUEEN_BANNER_PATTERN);
        this.slabBlock(output, "aurora_slab", (DeferredHolder<Block, ? extends Block>)TFBlocks.AURORA_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.AURORA_BLOCK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.AURORA_PILLAR.get()), (int)2).pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.AURORA_BLOCK.get()})).unlockedBy("has_slab", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.AURORA_SLAB.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.IRON_LADDER.get()), (int)3).pattern("-#-").pattern("-#-").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.IRON_BARS})).define(Character.valueOf('-'), Tags.Items.NUGGETS_IRON).unlockedBy("has_iron_bars", CraftingGenerator.has((ItemLike)Blocks.IRON_BARS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.WROUGHT_IRON_FENCE.get()), (int)3).pattern("###").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.WROUGHT_IRON_INGOTS).unlockedBy("has_wrought_iron", CraftingGenerator.has(ItemTagGenerator.WROUGHT_IRON_INGOTS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANDELABRA.get()), (int)2).pattern("###").pattern(" # ").define(Character.valueOf('#'), ItemTagGenerator.WROUGHT_IRON_INGOTS).unlockedBy("has_wrought_iron", CraftingGenerator.has(ItemTagGenerator.WROUGHT_IRON_INGOTS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.ROPE.get()), (int)8).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ROOT_STRAND.get()})).unlockedBy("has_root_strand", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ROOT_STRAND.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW.get()), (int)4).pattern("GPG").pattern("PPP").pattern("GPG").define(Character.valueOf('G'), Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS)).define(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CANOPY_PLANKS.value()})).unlockedBy("has_planks", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_PLANKS.value()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW_PANE.get()), (int)16).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CANOPY_WINDOW.value()})).unlockedBy("has_windows", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW.value()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFItems.MASON_JAR.get()), (int)4).pattern("GLG").pattern("G G").pattern("GGG").define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS})).define(Character.valueOf('L'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TWILIGHT_OAK_LOG.get()})).unlockedBy("has_tf_oak", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TWILIGHT_OAK_LOG.value()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.FIREFLY_JAR.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MASON_JAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIREFLY.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.FIREFLY_SPAWNER.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY_JAR.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.POPPY})).unlockedBy("has_jar", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIREFLY_JAR.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CICADA_JAR.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CICADA.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MASON_JAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CICADA.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MAGENTA_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.HUGE_WATER_LILY.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.HUGE_WATER_LILY.get()))).save(output, TwilightForestMod.prefix("waterlily_to_magenta"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.THORN_ROSE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.THORN_ROSE.get()))).save(output, TwilightForestMod.prefix("thorn_rose_to_red"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ROOT_STRAND.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ROOT_STRAND.get()))).group("sticks").save(output, TwilightForestMod.prefix("root_stick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.TORCH, (int)5).pattern("\u2234").pattern("|").define(Character.valueOf('\u2234'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.TORCHBERRIES.get()})).define(Character.valueOf('|'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.TORCHBERRIES.get()))).save(output, TwilightForestMod.prefix("berry_torch"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.UNCRAFTING_TABLE.get())).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.CRAFTING_TABLE).define(Character.valueOf('X'), (ItemLike)TFItems.MAZE_MAP_FOCUS.get()).unlockedBy("has_uncrafting_table", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()))).save(output.withConditions(new ICondition[]{UncraftingTableCondition.INSTANCE}), TwilightForestMod.prefix("uncrafting_table"));
        this.cookingRecipes(output, "smelted", RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, 200);
        this.cookingRecipes(output, "smoked", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
        this.cookingRecipes(output, "campfired", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
        this.ingotRecipes(output, "smelted", RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, 200);
        this.ingotRecipes(output, "blasted", RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, 100);
        this.crackedWoodRecipes(output);
        this.crackedStoneRecipes(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CANOPY_BOOKSHELF.get())).pattern("---").pattern("B B").pattern("---").define(Character.valueOf('-'), (ItemLike)TFBlocks.CANOPY_PLANKS.get()).define(Character.valueOf('B'), (ItemLike)Items.BOOK).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_PLANKS.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.ARMOR_SHARD.get()}), 9).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.ARMOR_SHARD.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.ARMOR_SHARD_CLUSTER.getId().getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_UNDERBRICK.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.UNDERBRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNDERBRICK.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_MAZESTONE.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.MAZESTONE_BRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.MAZESTONE_BRICK.get()))).save(output, TwilightForestMod.prefix("maze_stone/mossy_mazestone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.CARMINITE.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.BORER_ESSENCE.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.CARMINITE.getId().getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.RAW_IRONWOOD.get()), (int)2).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.LIVEROOT.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_IRON})).requires(Tags.Items.NUGGETS_GOLD).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.LIVEROOT.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.RAW_IRONWOOD.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.RAINY_CLOUD.get()), (int)8).pattern("ccc").pattern("cbc").pattern("ccc").define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FLUFFY_CLOUD.get()})).define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FLUFFY_CLOUD.get()))).save(output, TwilightForestMod.prefix("rainy_cloud"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.SNOWY_CLOUD.get()), (int)8).pattern("ccc").pattern("cbc").pattern("ccc").define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FLUFFY_CLOUD.get()})).define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.POWDER_SNOW_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FLUFFY_CLOUD.get()))).save(output, TwilightForestMod.prefix("snowy_cloud"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.MYSTIC_CROWN, (int)1).pattern("ttt").pattern("t t").pattern("ttt").define(Character.valueOf('t'), Ingredient.of((ItemLike[])new ItemLike[]{TFItems.CROWN_SPLINTER})).unlockedBy("has_item", CraftingGenerator.has(TFItems.CROWN_SPLINTER)).save(output);
    }

    private void darkTowerRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.ENCASED_FIRE_JET.get())).pattern("#\u2234#").pattern("\u2234^\u2234").pattern("uuu").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('^'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIRE_JET.get()})).define(Character.valueOf('u'), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIRE_JET.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.ENCASED_SMOKER.get())).pattern("#\u2234#").pattern("\u2234^\u2234").pattern("#\u2234#").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('^'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.SMOKER.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.SMOKER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.CARMINITE_BUILDER.get())).pattern("#6#").pattern("6o6").pattern("#6#").define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('o'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER})).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.CARMINITE_GEMS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.CARMINITE_REACTOR.get())).pattern("#6#").pattern("6%6").pattern("#6#").define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('%'), Tags.Items.ORES_REDSTONE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.CARMINITE_GEMS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()), (int)2).pattern("#\u2234#").pattern("\u22346\u2234").pattern("#\u2234#").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.VANISHING_BLOCK.get()), (int)8).pattern("#w#").pattern("w6w").pattern("#w#").define(Character.valueOf('w'), ItemTagGenerator.TOWERWOOD).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_TOWERWOOD.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TOWERWOOD.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TOWERWOOD.get()))).save(output, TwilightForestMod.prefix("wood/" + TFBlocks.MOSSY_TOWERWOOD.getId().getPath()));
    }

    private void equipmentRecipes(HolderLookup.Provider provider, RecipeOutput output) {
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_BOOTS, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)1)));
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_LEGGINGS, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)1)));
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_CHESTPLATE, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)1)));
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_HELMET, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.AQUA_AFFINITY, (Object)1)));
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_SWORD, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.KNOCKBACK, (Object)1)));
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_PICKAXE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)1)));
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_AXE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)1)));
        this.shovelItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_SHOVEL, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.UNBREAKING, (Object)1)));
        this.hoeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_HOE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)1)));
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_BOOTS, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)2)));
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_LEGGINGS, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FIRE_PROTECTION, (Object)2)));
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_CHESTPLATE, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.BLAST_PROTECTION, (Object)2)));
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_HELMET, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROJECTILE_PROTECTION, (Object)2)));
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_SWORD, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.LOOTING, (Object)2)));
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_PICKAXE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)2)));
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_AXE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)2)));
        this.shovelItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_SHOVEL, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)2)));
        this.hoeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_HOE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)2)));
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_BOOTS, ItemTagGenerator.ARCTIC_FUR);
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_CHESTPLATE, ItemTagGenerator.ARCTIC_FUR);
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_HELMET, ItemTagGenerator.ARCTIC_FUR);
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_LEGGINGS, ItemTagGenerator.ARCTIC_FUR);
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_BOOTS, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_CHESTPLATE, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_HELMET, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_LEGGINGS, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_PICKAXE, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_SWORD, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_AXE, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_BOOTS).pattern("# #").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_boots").save(output, this.locEquip(TFItems.FIERY_BOOTS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_LEGGINGS).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_leggings").save(output, this.locEquip(TFItems.FIERY_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_CHESTPLATE).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_chestplate").save(output, this.locEquip(TFItems.FIERY_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_HELMET).pattern("###").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_helmet").save(output, this.locEquip(TFItems.FIERY_HELMET.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, TFItems.FIERY_PICKAXE).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_pickaxe").save(output, this.locEquip(TFItems.FIERY_PICKAXE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_SWORD).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_sword").save(output, this.locEquip(TFItems.FIERY_SWORD.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.NAGA_CHESTPLATE, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.FIRE_PROTECTION, (Object)3)).build())).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), TFItems.NAGA_SCALE).unlockedBy("has_item", CraftingGenerator.has(TFItems.NAGA_SCALE)).save(output, this.locEquip(TFItems.NAGA_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.NAGA_LEGGINGS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)3)).build())).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.NAGA_SCALE).unlockedBy("has_item", CraftingGenerator.has(TFItems.NAGA_SCALE)).save(output, this.locEquip(TFItems.NAGA_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_HELMET, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("###").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_HELMET.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_CHESTPLATE, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_LEGGINGS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_BOOTS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2), Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)4)).build())).pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_BOOTS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.GIANT_PICKAXE.get())).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), (ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).define(Character.valueOf('X'), (ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, this.locEquip(TFItems.GIANT_PICKAXE.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.GIANT_SWORD.get())).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).define(Character.valueOf('X'), (ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, this.locEquip(TFItems.GIANT_SWORD.getId().getPath()));
        this.charmRecipe(output, "charm_of_keeping_2", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_2, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_1);
        this.charmRecipe(output, "charm_of_keeping_3", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_3, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_2);
        this.charmRecipe(output, "charm_of_life_2", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_LIFE_2, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_LIFE_1);
        SpecialRecipeBuilder.special(MoonwormQueenRepairRecipe::new).save(output, TwilightForestMod.prefix("moonworm_queen_repair_recipe").toString());
        SpecialRecipeBuilder.special(MagicMapCloningRecipe::new).save(output, TwilightForestMod.prefix("magic_map_cloning_recipe").toString());
        SpecialRecipeBuilder.special(MazeMapCloningRecipe::new).save(output, TwilightForestMod.prefix("maze_map_cloning_recipe").toString());
        SpecialRecipeBuilder.special(EmperorsClothRecipe::new).save(output, TwilightForestMod.prefix("emperors_cloth_recipe").toString());
        SpecialRecipeBuilder.special(CasketRepairRecipe::new).save(output, TwilightForestMod.prefix("casket_repair_recipe").toString());
        SpecialRecipeBuilder.special(EssenceRepairRecipe::new).save(output, TwilightForestMod.prefix("essence_repair_recipe").toString());
        NoSmithingTemplateRecipeBuilder.noTemplate(Ingredient.of((TagKey)Tags.Items.ARMORS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.EMPERORS_CLOTH.get()}), RecipeCategory.MISC).attachData(() -> TFDataComponents.EMPERORS_CLOTH.value(), Unit.INSTANCE).unlocks("has_cloth", CraftingGenerator.has(TFItems.EMPERORS_CLOTH)).save(output, TwilightForestMod.prefix("emperors_cloth_smithing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE, (int)64).requires((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_COBBLESTONE.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.COBBLESTONE).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OAK_PLANKS, (int)64).requires((ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_LOG.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_LOG.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OAK_PLANKS).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OAK_LEAVES, (int)64).requires((ItemLike)TFBlocks.GIANT_LEAVES.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_LEAVES.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_LEAVES.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OAK_LEAVES).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OBSIDIAN, (int)64).requires((ItemLike)TFBlocks.GIANT_OBSIDIAN.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_OBSIDIAN.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_OBSIDIAN.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OBSIDIAN).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.BLOCK_AND_CHAIN.get())).requires(Ingredient.of(ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL)).requires(Ingredient.of(ItemTagGenerator.KNIGHTMETAL_INGOTS), 3).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_RING.get()})).unlockedBy("has_block", CraftingGenerator.has(ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL)).unlockedBy("has_ingot", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).unlockedBy("has_ring", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get()))).save(output, this.locEquip(TFItems.BLOCK_AND_CHAIN.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get())).pattern(" - ").pattern("- -").pattern(" - ").define(Character.valueOf('-'), ItemTagGenerator.KNIGHTMETAL_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).save(output, this.locEquip(TFItems.KNIGHTMETAL_RING.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_SHIELD.get())).pattern("-#").pattern("-o").pattern("-#").define(Character.valueOf('-'), ItemTagGenerator.KNIGHTMETAL_INGOTS).define(Character.valueOf('#'), ItemTagGenerator.TOWERWOOD).define(Character.valueOf('o'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_RING.get()})).unlockedBy("has_ingot", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).unlockedBy("has_ring", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get()))).save(output, this.locEquip(TFItems.KNIGHTMETAL_SHIELD.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.LIFEDRAIN_SCEPTER.get(), 9).addRepairIngredient((ItemLike)Items.FERMENTED_SPIDER_EYE).save(output, this.locEquip(TFItems.LIFEDRAIN_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.FORTIFICATION_SCEPTER.get(), 9).addRepairIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).save(output, this.locEquip(TFItems.FORTIFICATION_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.TWILIGHT_SCEPTER.get(), 9).addRepairIngredient((TagKey<Item>)Tags.Items.ENDER_PEARLS).save(output, this.locEquip(TFItems.TWILIGHT_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.ZOMBIE_SCEPTER.get(), 9).addRepairIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRENGTH), (ItemLike[])new ItemLike[]{Items.POTION}), DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.LONG_STRENGTH), (ItemLike[])new ItemLike[]{Items.POTION}), DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_STRENGTH), (ItemLike[])new ItemLike[]{Items.POTION})})).addRepairIngredient((ItemLike)Items.ROTTEN_FLESH).save(output, this.locEquip(TFItems.ZOMBIE_SCEPTER.getId().getPath()));
    }

    private void blockCompressionRecipes(RecipeOutput output) {
        this.reverseCompressBlock(output, "arctic_block_to_item", (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_FUR, ItemTagGenerator.STORAGE_BLOCKS_ARCTIC_FUR);
        this.reverseCompressBlock(output, "carminite_block_to_item", (DeferredHolder<Item, ? extends Item>)TFItems.CARMINITE, ItemTagGenerator.STORAGE_BLOCKS_CARMINITE);
        this.reverseCompressBlock(output, "ironwood_block_ingot", (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_INGOT, ItemTagGenerator.STORAGE_BLOCKS_IRONWOOD);
        this.reverseCompressBlock(output, "knightmetal_block_ingot", (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_INGOT, ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL);
        this.reverseCompressBlock(output, "steeleaf_block_ingot", (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_INGOT, ItemTagGenerator.STORAGE_BLOCKS_STEELEAF);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, TFItems.FIERY_INGOT, (int)9).requires(ItemTagGenerator.STORAGE_BLOCKS_FIERY).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.STORAGE_BLOCKS_FIERY)).group("fiery_ingot").save(output, TwilightForestMod.prefix("compressed_blocks/reversed/fiery_block_to_ingot"));
        this.compressedBlock(output, "arctic_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.ARCTIC_FUR_BLOCK, ItemTagGenerator.ARCTIC_FUR);
        this.compressedBlock(output, "carminite_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.CARMINITE_BLOCK, ItemTagGenerator.CARMINITE_GEMS);
        this.compressedBlock(output, "fiery_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.FIERY_BLOCK, ItemTagGenerator.FIERY_INGOTS);
        this.compressedBlock(output, "ironwood_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.IRONWOOD_BLOCK, ItemTagGenerator.IRONWOOD_INGOTS);
        this.compressedBlock(output, "knightmetal_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.KNIGHTMETAL_BLOCK, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.compressedBlock(output, "steeleaf_block", (DeferredHolder<Block, ? extends Block>)TFBlocks.STEELEAF_BLOCK, ItemTagGenerator.STEELEAF_INGOTS);
    }

    private void emptyMapRecipes(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAGIC_MAP_FOCUS.get())).requires((ItemLike)TFItems.RAVEN_FEATHER.get()).requires((ItemLike)TFItems.TORCHBERRIES.get()).requires(Tags.Items.DUSTS_GLOWSTONE).unlockedBy("has_berries", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.TORCHBERRIES.get()))).unlockedBy("has_feather", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAVEN_FEATHER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAGIC_MAP.get())).pattern("###").pattern("#\u2022#").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.PAPER).define(Character.valueOf('\u2022'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MAGIC_MAP_FOCUS.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAGIC_MAP_FOCUS.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAZE_MAP.get())).pattern("###").pattern("#\u2022#").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.PAPER).define(Character.valueOf('\u2022'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MAZE_MAP_FOCUS.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAZE_MAP_FOCUS.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.ORE_MAP.get())).requires((ItemLike)TFItems.MAZE_MAP.get()).requires(Tags.Items.STORAGE_BLOCKS_DIAMOND).requires(Tags.Items.STORAGE_BLOCKS_GOLD).requires(Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAZE_MAP.get()))).save(output);
    }

    private void woodRecipes(RecipeOutput output) {
        this.buttonBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.buttonBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.buttonBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.buttonBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.buttonBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.buttonBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.buttonBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.buttonBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_BUTTON, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.doorBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.doorBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.doorBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.doorBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.doorBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.doorBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.doorBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.doorBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_DOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.fenceBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.fenceBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.fenceBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.fenceBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.fenceBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.fenceBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.fenceBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.fenceBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_FENCE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.gateBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.gateBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.gateBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.gateBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.gateBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.gateBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.gateBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.gateBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_GATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.planksBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS, ItemTagGenerator.CANOPY_LOGS);
        this.planksBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS, ItemTagGenerator.DARKWOOD_LOGS);
        this.planksBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS, ItemTagGenerator.MANGROVE_LOGS);
        this.planksBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS, ItemTagGenerator.MINING_LOGS);
        this.planksBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS, ItemTagGenerator.SORTING_LOGS);
        this.planksBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS, ItemTagGenerator.TIME_LOGS);
        this.planksBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS, ItemTagGenerator.TRANSFORMATION_LOGS);
        this.planksBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS, ItemTagGenerator.TWILIGHT_OAK_LOGS);
        this.woodBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_LOG);
        this.woodBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_LOG);
        this.woodBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_LOG);
        this.woodBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_LOG);
        this.woodBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_LOG);
        this.woodBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_LOG);
        this.woodBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_LOG);
        this.woodBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_LOG);
        this.strippedWoodBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_CANOPY_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_CANOPY_LOG);
        this.strippedWoodBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_DARK_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_DARK_LOG);
        this.strippedWoodBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MANGROVE_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MANGROVE_LOG);
        this.strippedWoodBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MINING_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MINING_LOG);
        this.strippedWoodBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_SORTING_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_SORTING_LOG);
        this.strippedWoodBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TIME_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TIME_LOG);
        this.strippedWoodBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TRANSFORMATION_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TRANSFORMATION_LOG);
        this.strippedWoodBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG);
        this.plateBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.plateBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.plateBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.plateBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.plateBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.plateBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.plateBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.plateBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLATE, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.woodenSlabBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.woodenSlabBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.woodenSlabBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.woodenSlabBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.woodenSlabBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.woodenSlabBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.woodenSlabBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.woodenSlabBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_SLAB, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.woodenStairsBlock(output, this.locWood("canopy_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS, (ItemLike)TFBlocks.CANOPY_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("dark_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS, (ItemLike)TFBlocks.DARK_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("mangrove_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS, (ItemLike)TFBlocks.MANGROVE_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("mining_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS, (ItemLike)TFBlocks.MINING_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("sorting_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS, (ItemLike)TFBlocks.SORTING_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("time_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS, (ItemLike)TFBlocks.TIME_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("transformation_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS, (ItemLike)TFBlocks.TRANSFORMATION_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("twilight_oak_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS, (ItemLike)TFBlocks.TWILIGHT_OAK_PLANKS.get());
        this.trapdoorBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.trapdoorBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.trapdoorBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.trapdoorBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.trapdoorBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.trapdoorBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.trapdoorBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.trapdoorBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.signBlock(output, "canopy", (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.signBlock(output, "dark", (DeferredHolder<Item, ? extends Item>)TFItems.DARK_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.signBlock(output, "mangrove", (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.signBlock(output, "mining", (DeferredHolder<Item, ? extends Item>)TFItems.MINING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.signBlock(output, "sorting", (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.signBlock(output, "time", (DeferredHolder<Item, ? extends Item>)TFItems.TIME_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.signBlock(output, "transformation", (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.signBlock(output, "twilight_oak", (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.hangingSignBlock(output, "canopy", (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_CANOPY_LOG);
        this.hangingSignBlock(output, "dark", (DeferredHolder<Item, ? extends Item>)TFItems.DARK_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_DARK_LOG);
        this.hangingSignBlock(output, "mangrove", (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MANGROVE_LOG);
        this.hangingSignBlock(output, "mining", (DeferredHolder<Item, ? extends Item>)TFItems.MINING_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_MINING_LOG);
        this.hangingSignBlock(output, "sorting", (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_SORTING_LOG);
        this.hangingSignBlock(output, "time", (DeferredHolder<Item, ? extends Item>)TFItems.TIME_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TIME_LOG);
        this.hangingSignBlock(output, "transformation", (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TRANSFORMATION_LOG);
        this.hangingSignBlock(output, "twilight_oak", (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_HANGING_SIGN, (DeferredHolder<Block, ? extends Block>)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG);
        this.banisterBlock(output, "canopy", (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_SLAB);
        this.banisterBlock(output, "dark", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_SLAB);
        this.banisterBlock(output, "mangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_SLAB);
        this.banisterBlock(output, "mining", (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_SLAB);
        this.banisterBlock(output, "sorting", (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_SLAB);
        this.banisterBlock(output, "time", (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_SLAB);
        this.banisterBlock(output, "transformation", (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_SLAB);
        this.banisterBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_BANISTER, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_SLAB);
        this.banisterBlock(output, "oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.OAK_BANISTER, Blocks.OAK_SLAB);
        this.banisterBlock(output, "spruce", (DeferredHolder<Block, ? extends Block>)TFBlocks.SPRUCE_BANISTER, Blocks.SPRUCE_SLAB);
        this.banisterBlock(output, "birch", (DeferredHolder<Block, ? extends Block>)TFBlocks.BIRCH_BANISTER, Blocks.BIRCH_SLAB);
        this.banisterBlock(output, "jungle", (DeferredHolder<Block, ? extends Block>)TFBlocks.JUNGLE_BANISTER, Blocks.JUNGLE_SLAB);
        this.banisterBlock(output, "acacia", (DeferredHolder<Block, ? extends Block>)TFBlocks.ACACIA_BANISTER, Blocks.ACACIA_SLAB);
        this.banisterBlock(output, "dark_oak", (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_OAK_BANISTER, Blocks.DARK_OAK_SLAB);
        this.banisterBlock(output, "crimson", (DeferredHolder<Block, ? extends Block>)TFBlocks.CRIMSON_BANISTER, Blocks.CRIMSON_SLAB);
        this.banisterBlock(output, "warped", (DeferredHolder<Block, ? extends Block>)TFBlocks.WARPED_BANISTER, Blocks.WARPED_SLAB);
        this.banisterBlock(output, "vangrove", (DeferredHolder<Block, ? extends Block>)TFBlocks.VANGROVE_BANISTER, Blocks.MANGROVE_SLAB);
        this.banisterBlock(output, "bamboo", (DeferredHolder<Block, ? extends Block>)TFBlocks.BAMBOO_BANISTER, Blocks.BAMBOO_SLAB);
        this.banisterBlock(output, "cherry", (DeferredHolder<Block, ? extends Block>)TFBlocks.CHERRY_BANISTER, Blocks.CHERRY_SLAB);
        this.chestBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TWILIGHT_OAK_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.TWILIGHT_OAK_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.chestBlock(output, "canopy", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.CANOPY_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.CANOPY_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.chestBlock(output, "mangrove", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MANGROVE_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.MANGROVE_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.chestBlock(output, "dark", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.DARK_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.DARK_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.chestBlock(output, "time", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TIME_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.TIME_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.chestBlock(output, "transformation", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TRANSFORMATION_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.TRANSFORMATION_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.chestBlock(output, "mining", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MINING_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.MINING_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.chestBlock(output, "sorting", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.SORTING_CHEST, (DeferredHolder<Block, ? extends TFTrappedChestBlock>)TFBlocks.SORTING_TRAPPED_CHEST, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.DARK_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.DARK_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.DARK_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TIME_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TIME_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.TIME_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.MINING_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.MINING_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.MINING_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_CHEST_BOAT, (DeferredHolder<Block, ? extends Block>)TFBlocks.SORTING_PLANKS);
    }

    private void nagastoneRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.SPIRAL_BRICKS.get()), (int)8).pattern("BSS").pattern("BSS").pattern("BBB").define(Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE_BRICKS, Blocks.MOSSY_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.CHISELED_STONE_BRICKS})).define(Character.valueOf('S'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE_SLAB, Blocks.STONE_BRICK_SLAB})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.SPIRAL_BRICKS.get()))).save(output, this.locNaga("nagastone_spiral"));
        this.stairsBlock(output, this.locNaga("nagastone_stairs_left"), (DeferredHolder<Block, ? extends Block>)TFBlocks.NAGASTONE_STAIRS_LEFT, (DeferredHolder<Block, ? extends Block>)TFBlocks.ETCHED_NAGASTONE, (ItemLike)TFBlocks.ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("nagastone_stairs_right"), (DeferredHolder<Block, ? extends Block>)TFBlocks.NAGASTONE_STAIRS_RIGHT, (DeferredHolder<Block, ? extends Block>)TFBlocks.ETCHED_NAGASTONE, (ItemLike)TFBlocks.ETCHED_NAGASTONE.get());
        this.stairsBlock(output, this.locNaga("mossy_nagastone_stairs_left"), (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT, (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_ETCHED_NAGASTONE, (ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("mossy_nagastone_stairs_right"), (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT, (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_ETCHED_NAGASTONE, (ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ETCHED_NAGASTONE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ETCHED_NAGASTONE.get()))).save(output, this.locNaga("mossy_etched_nagastone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_NAGASTONE_PILLAR.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.NAGASTONE_PILLAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.NAGASTONE_PILLAR.get()))).save(output, this.locNaga("mossy_nagastone_pillar"));
        this.stairsBlock(output, this.locNaga("cracked_nagastone_stairs_left"), (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT, (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_ETCHED_NAGASTONE, (ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("cracked_nagastone_stairs_right"), (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT, (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_ETCHED_NAGASTONE, (ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get());
    }

    private void castleRecipes(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("mossy_castle_brick"));
        this.castleBlock(output, (DeferredHolder<Block, ? extends Block>)TFBlocks.THICK_CASTLE_BRICK, (ItemLike)TFBlocks.CASTLE_BRICK.get(), (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get(), (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get(), (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get());
        this.castleBlock(output, (DeferredHolder<Block, ? extends Block>)TFBlocks.BOLD_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.THICK_CASTLE_BRICK.get());
        this.castleBlock(output, (DeferredHolder<Block, ? extends Block>)TFBlocks.BOLD_CASTLE_BRICK_TILE, (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get()), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get()})).unlockedBy("has_castle_brick", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("bold_castle_pillar_from_tile"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get()), (int)6).pattern("#H#").pattern("#H#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get(), (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get(), (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get(), (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get(), (ItemLike)TFBlocks.THICK_CASTLE_BRICK.get()})).define(Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get()})).unlockedBy("has_castle_brick", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("encased_castle_pillar"));
        this.stairsBlock(output, this.locCastle("bold_castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.BOLD_CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.BOLD_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get());
        this.stairsBlock(output, this.locCastle("castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.CASTLE_BRICK, (ItemLike)TFBlocks.CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("cracked_castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.CRACKED_CASTLE_BRICK, (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("encased_castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.ENCASED_CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get());
        this.stairsBlock(output, this.locCastle("mossy_castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.MOSSY_CASTLE_BRICK, (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("worn_castle_brick_stairs"), (DeferredHolder<Block, ? extends Block>)TFBlocks.WORN_CASTLE_BRICK_STAIRS, (DeferredHolder<Block, ? extends Block>)TFBlocks.WORN_CASTLE_BRICK, (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get());
    }

    private void fieryConversions(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.FIERY_INGOT.get())).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL)).requires(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_ingot").save(output, this.locEquip("fiery_ingot_crafting"));
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_HELMET, Items.IRON_HELMET, 5);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_CHESTPLATE, Items.IRON_CHESTPLATE, 8);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_LEGGINGS, Items.IRON_LEGGINGS, 7);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_BOOTS, Items.IRON_BOOTS, 4);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.FIERY_SWORD.get())).requires((ItemLike)Items.IRON_SWORD).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL), 2).requires(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE)).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_sword").save(output, this.locEquip("fiery_" + BuiltInRegistries.ITEM.getKey((Object)Items.IRON_SWORD).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.FIERY_PICKAXE.get())).requires((ItemLike)Items.IRON_PICKAXE).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL), 3).requires(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), 2).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_pickaxe").save(output, this.locEquip("fiery_" + BuiltInRegistries.ITEM.getKey((Object)Items.IRON_PICKAXE).getPath()));
    }

    private <T extends AbstractCookingRecipe> void cookingRecipes(RecipeOutput output, String processName, RecipeSerializer<T> process, AbstractCookingRecipe.Factory<T> factory, int smeltingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_MEEF.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TFItems.COOKED_MEEF.get()), (float)0.35f, (int)smeltingTime, process, factory).unlockedBy("has_food", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_MEEF.get()))).save(output, TwilightForestMod.prefix("food/" + processName + "_meef").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_VENISON.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TFItems.COOKED_VENISON.get()), (float)0.35f, (int)smeltingTime, process, factory).unlockedBy("has_food", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_VENISON.get()))).save(output, TwilightForestMod.prefix("food/" + processName + "_venison").toString());
    }

    private <T extends AbstractCookingRecipe> void ingotRecipes(RecipeOutput output, String processName, RecipeSerializer<T> process, AbstractCookingRecipe.Factory<T> factory, int smeltingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_INGOT.get()), (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get()))).group("knightmetal_ingot").save(output, TwilightForestMod.prefix("material/" + processName + "_knightmetal_ingot").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_IRONWOOD.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.IRONWOOD_INGOT.get()), (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_IRONWOOD.get()))).group("ironwood_ingot").save(output, TwilightForestMod.prefix("material/" + processName + "_ironwood_ingot").toString());
    }

    private void crackedWoodRecipes(RecipeOutput output) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TOWERWOOD.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_TOWERWOOD.get()), (float)0.1f, (int)100).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TOWERWOOD.get()))).save(output, TwilightForestMod.prefix("wood/smoked_cracked_towerwood").toString());
    }

    private void crackedStoneRecipes(RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.NAGASTONE_PILLAR.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_NAGASTONE_PILLAR.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.NAGASTONE_PILLAR.get()))).save(output, TwilightForestMod.prefix("nagastone/smelted_cracked_nagastone_pillar").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ETCHED_NAGASTONE.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ETCHED_NAGASTONE.get()))).save(output, TwilightForestMod.prefix("nagastone/smelted_cracked_etched_nagastone").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.MAZESTONE_BRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_MAZESTONE.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.MAZESTONE_BRICK.get()))).save(output, TwilightForestMod.prefix("maze_stone/smelted_maze_stone_cracked").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, TwilightForestMod.prefix("castleblock/smelted_cracked_castle_brick").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.UNDERBRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_UNDERBRICK.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNDERBRICK.get()))).save(output, TwilightForestMod.prefix("smelted_cracked_underbrick").toString());
    }
}

