/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.BlockstateGenerator;
import twilightforest.data.CraftingGenerator;
import twilightforest.data.DataMapGenerator;
import twilightforest.data.ItemModelGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.data.LootGenerator;
import twilightforest.data.LootModifierGenerator;
import twilightforest.data.ParticleGenerator;
import twilightforest.data.RegistryDataGenerator;
import twilightforest.data.SoundGenerator;
import twilightforest.data.TFAdvancementProvider;
import twilightforest.data.TFStructureUpdater;
import twilightforest.data.custom.QuestGenerator;
import twilightforest.data.custom.StructureTemplateDefinitionGenerator;
import twilightforest.data.custom.stalactites.StalactiteGenerator;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.CustomTagGenerator;
import twilightforest.data.tags.DamageTypeTagGenerator;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.data.tags.StructureTagGenerator;

@EventBusSubscriber(modid="twilightforest", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockstateGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ParticleGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new SoundGenerator(output, helper));
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(output, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BannerPatternTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.DimensionTypeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.WoodPaletteTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.PaintingVariantTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DamageTypeTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TFAdvancementProvider(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new StalactiteGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new TFStructureUpdater("structures", output, helper));
        BlockTagGenerator blocktags = new BlockTagGenerator(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocktags);
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BlockEntityTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(output, lookupProvider, blocktags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new CraftingGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierGenerator(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new StructureTemplateDefinitionGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new AtlasGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new LangGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new QuestGenerator(output));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Twilight Forest"), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))));
    }
}

