/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.entity.projectile.ThrownWep;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class PhantomThrowWeaponGoal
extends Goal {
    private final KnightPhantom boss;

    public PhantomThrowWeaponGoal(KnightPhantom entity) {
        this.boss = entity;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.boss.getTarget() != null && this.boss.getCurrentFormation() == KnightPhantom.Formation.ATTACK_PLAYER_ATTACK;
    }

    public void tick() {
        if (this.boss.getTarget() != null && this.boss.getTicksProgress() % 4 == 0) {
            if (this.boss.isAxeKnight()) {
                this.launchAxeAt((Entity)this.boss.getTarget());
            } else if (this.boss.isPickKnight()) {
                this.launchPicks();
            }
        }
    }

    private void launchAxeAt(Entity targetedEntity) {
        float bodyFacingAngle = this.boss.yBodyRot * (float)Math.PI / 180.0f;
        double sx = this.boss.getX() + (double)(Mth.cos((float)bodyFacingAngle) * 1.0f);
        double sy = this.boss.getY() + (double)this.boss.getBbHeight() * 0.82;
        double sz = this.boss.getZ() + (double)(Mth.sin((float)bodyFacingAngle) * 1.0f);
        double tx = targetedEntity.getX() - sx;
        double ty = targetedEntity.getBoundingBox().minY + (double)(targetedEntity.getBbHeight() / 2.0f) - (this.boss.getY() + (double)(this.boss.getBbHeight() / 2.0f));
        double tz = targetedEntity.getZ() - sz;
        this.boss.playSound((SoundEvent)TFSounds.KNIGHT_PHANTOM_THROW_AXE.get(), 1.0f, (this.boss.getRandom().nextFloat() - this.boss.getRandom().nextFloat()) * 0.2f + 0.4f);
        this.boss.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        ThrownWep projectile = new ThrownWep((EntityType<? extends ThrownWep>)((EntityType)TFEntities.THROWN_WEP.get()), this.boss.level(), (LivingEntity)this.boss).setItem(new ItemStack((ItemLike)TFItems.KNIGHTMETAL_AXE.get()));
        float speed = 0.75f;
        projectile.shoot(tx, ty, tz, speed, 1.0f);
        projectile.moveTo(sx, sy, sz, this.boss.getYRot(), this.boss.getXRot());
        this.boss.level().addFreshEntity((Entity)projectile);
    }

    private void launchPicks() {
        this.boss.playSound((SoundEvent)TFSounds.KNIGHT_PHANTOM_THROW_PICK.get(), 1.0f, (this.boss.getRandom().nextFloat() - this.boss.getRandom().nextFloat()) * 0.2f + 0.4f);
        this.boss.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)i * (float)Math.PI / 4.0f;
            double sx = this.boss.getX() + (double)(Mth.cos((float)throwAngle) * 1.0f);
            double sy = this.boss.getY() + (double)this.boss.getBbHeight() * 0.82;
            double sz = this.boss.getZ() + (double)(Mth.sin((float)throwAngle) * 1.0f);
            double vx = Mth.cos((float)throwAngle);
            double vy = 0.0;
            double vz = Mth.sin((float)throwAngle);
            ThrownWep projectile = new ThrownWep((EntityType<? extends ThrownWep>)((EntityType)TFEntities.THROWN_WEP.get()), this.boss.level(), (LivingEntity)this.boss).setDamage(3.0f).setVelocity(0.015f).setItem(new ItemStack((ItemLike)TFItems.KNIGHTMETAL_PICKAXE.get()));
            projectile.moveTo(sx, sy, sz, (float)i * 45.0f, this.boss.getXRot());
            float speed = 0.5f;
            projectile.shoot(vx, vy, vz, speed, 1.0f);
            this.boss.level().addFreshEntity((Entity)projectile);
        }
    }
}

