/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.config.TFConfig;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;

public interface IBossLootBuffer {
    public static final int CONTAINER_SIZE = 27;

    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItemStacks().get(slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItemStacks().set(slot, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
    }

    default public void addDeathItemsSaveData(CompoundTag tag, RegistryAccess registryAccess) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)registryAccess);
    }

    default public void readDeathItemsSaveData(CompoundTag tag, RegistryAccess registryAccess) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.getItemStacks(), (HolderLookup.Provider)registryAccess);
    }

    public static <T extends LivingEntity> void saveDropsIntoBoss(T boss, LootParams params, ServerLevel serverLevel) {
        if (TFConfig.bossDropChests) {
            LootTable table = serverLevel.getServer().reloadableRegistries().getLootTable(boss.getLootTable());
            ObjectArrayList stacks = table.getRandomItems(params);
            ((IBossLootBuffer)boss).fill(boss, params, table);
            if (stacks.size() > 27) {
                for (ItemStack stack : stacks.subList(28, stacks.size())) {
                    ItemEntity item = new ItemEntity((Level)serverLevel, boss.getX(), boss.getY(), boss.getZ(), stack);
                    item.setExtendedLifetime();
                    item.setNoPickUpDelay();
                    serverLevel.addFreshEntity((Entity)item);
                }
            }
        }
    }

    public static <T extends LivingEntity> void depositDropsIntoChest(T boss, BlockState chest, BlockPos pos, ServerLevel serverLevel) {
        if (TFConfig.bossDropChests && !((IBossLootBuffer)boss).getItemStacks().isEmpty()) {
            if (!IBossLootBuffer.tryDeposit(boss, chest, pos, serverLevel)) {
                BlockPos.MutableBlockPos chestPos = pos.mutable();
                for (int y = pos.getY(); y < serverLevel.getMaxBuildHeight(); ++y) {
                    chestPos.setY(y);
                    if (!IBossLootBuffer.tryDeposit(boss, chest, (BlockPos)chestPos, serverLevel)) continue;
                    return;
                }
            } else {
                return;
            }
            for (int i = 0; i < 27; ++i) {
                Block.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)((IBossLootBuffer)boss).getItem(i));
            }
            IBossLootBuffer.celebrateAt(boss, pos.getCenter(), serverLevel);
        }
    }

    public static <T extends LivingEntity> boolean tryDeposit(T boss, BlockState chest, BlockPos pos, ServerLevel serverLevel) {
        BlockEntity blockEntity;
        if ((serverLevel.getBlockState(pos).is(chest.getBlock()) || (serverLevel.getBlockState(pos).canBeReplaced() || serverLevel.getBlockState(pos).getPistonPushReaction() != PushReaction.BLOCK) && serverLevel.getBlockEntity(pos) == null && serverLevel.setBlock(pos, chest, 2)) && (blockEntity = serverLevel.getBlockEntity(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < 27 && i < container.getContainerSize(); ++i) {
                container.setItem(i, ((IBossLootBuffer)boss).getItem(i));
            }
            IBossLootBuffer.celebrateAt(boss, pos.getCenter(), serverLevel);
            return true;
        }
        return false;
    }

    public static <T extends LivingEntity> void celebrateAt(T boss, Vec3 vec3, ServerLevel serverLevel) {
        serverLevel.playSound(null, vec3.x, vec3.y, vec3.z, (SoundEvent)TFSounds.BOSS_CHEST_APPEAR.get(), boss.getSoundSource(), 128.0f, (boss.getRandom().nextFloat() - boss.getRandom().nextFloat()) * 0.175f + 0.5f);
        ParticlePacket particlePacket = new ParticlePacket();
        for (int i = 0; i < 40; ++i) {
            double x = (boss.getRandom().nextDouble() - 0.5) * 0.075 * (double)i;
            double y = (boss.getRandom().nextDouble() - 0.5) * 0.075 * (double)i;
            double z = (boss.getRandom().nextDouble() - 0.5) * 0.075 * (double)i;
            particlePacket.queueParticle((ParticleOptions)ParticleTypes.POOF, false, vec3.add(x, y, z), Vec3.ZERO);
        }
        PacketDistributor.sendToPlayersTrackingEntity(boss, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public <T extends LivingEntity> void fill(T boss, LootParams context, LootTable table) {
        ObjectArrayList items = table.getRandomItems(context);
        RandomSource randomsource = boss.getRandom();
        List<Integer> list = this.getAvailableSlots(randomsource);
        table.shuffleAndSplitItems(items, list.size(), randomsource);
        for (ItemStack itemstack : items) {
            if (list.isEmpty()) continue;
            this.setItem(list.removeLast(), itemstack.isEmpty() ? ItemStack.EMPTY : itemstack);
        }
    }

    default public List<Integer> getAvailableSlots(RandomSource random) {
        ObjectArrayList arrayList = new ObjectArrayList();
        for (int i = 0; i < 27; ++i) {
            arrayList.add((Object)i);
        }
        Util.shuffle((List)arrayList, (RandomSource)random);
        return arrayList;
    }

    public NonNullList<ItemStack> getItemStacks();
}

