/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client;

import fabric.com.hollingsworth.schematic.client.AreaCaptureHandler;
import fabric.com.hollingsworth.schematic.client.KeyEvent;
import fabric.com.hollingsworth.schematic.client.RenderStructureHandler;
import fabric.com.hollingsworth.schematic.client.gui.HomeScreen;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class ClientData {
    private static final String CATEGORY = "key.category.blockprints.general";
    public static final class_304 OPEN_MENU = new class_304("key.blockprints.open_menu", 96, "key.category.blockprints.general");
    public static final class_304 CONFIRM = new class_304("key.blockprints.confirm_selection", 257, "key.category.blockprints.general");
    public static final class_304 CANCEL = new class_304("key.blockprints.cancel_selection", 259, "key.category.blockprints.general");
    public static final class_304 TOOL_MENU = new class_304("key.blockprints.tool_menu", 342, "key.category.blockprints.general");
    public static final KeyFunction[] KEY_FUNCTIONS = new KeyFunction[]{new KeyFunction(OPEN_MENU, ClientData::openMenu), new KeyFunction(CONFIRM, ClientData::onConfirmHit), new KeyFunction(CANCEL, ClientData::onCancelHit), new KeyFunction(TOOL_MENU, RenderStructureHandler::toolKeyHit)};

    public static void openMenu(KeyEvent event) {
        if (event.isDown()) {
            class_310.method_1551().method_1507((class_437)new HomeScreen());
        }
    }

    public static void startBoundaryCapture() {
        AreaCaptureHandler.startCapture();
        RenderStructureHandler.cancelRender();
    }

    public static void startStructureRenderer(class_3499 structureTemplate, String name, String blockprintsId) {
        RenderStructureHandler.startRender(structureTemplate, name, blockprintsId);
        AreaCaptureHandler.cancelCapture();
    }

    public static void onConfirmHit(KeyEvent event) {
        if (!event.isDown()) {
            return;
        }
        AreaCaptureHandler.onConfirmHit();
    }

    public static void onCancelHit(KeyEvent event) {
        if (!event.isDown()) {
            return;
        }
        AreaCaptureHandler.onCancelHit();
    }

    public static void renderAfterSky(class_4587 poseStack, Matrix4f modelViewMatrix) {
        AreaCaptureHandler.renderBoundary(poseStack, modelViewMatrix);
    }

    public static void renderAfterTransparentBlocks(class_4587 poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix) {
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.buildRender(data, poseStack, (class_1657)class_310.method_1551().field_1724);
        }
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.drawRender(data, poseStack, projectionMatrix, modelViewMatrix, (class_1657)class_310.method_1551().field_1724);
        }
    }

    public static boolean mouseScrolled(double delta) {
        return RenderStructureHandler.mouseScrolled(delta) || AreaCaptureHandler.mouseScrolled(delta);
    }

    public static void rightClickEvent() {
        AreaCaptureHandler.positionClicked();
        RenderStructureHandler.positionClicked();
    }

    public static void renderGUIOverlayEvent(class_332 graphics, class_1041 window) {
        AreaCaptureHandler.renderBoundaryUI(graphics, window);
        RenderStructureHandler.renderInstructions(graphics, window);
    }

    public static void tickEvent() {
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        RenderStructureHandler.tick();
        AreaCaptureHandler.tick();
    }

    public record KeyFunction(class_304 mapping, Consumer<KeyEvent> function) {
    }
}

