/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client;

import fabric.com.hollingsworth.schematic.client.KeyEvent;
import fabric.com.hollingsworth.schematic.client.RaycastHelper;
import fabric.com.hollingsworth.schematic.client.gui.PlaceSchematicScreen;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import fabric.com.hollingsworth.schematic.networking.PlaceSchematicPacket;
import fabric.com.hollingsworth.schematic.platform.Services;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;

public class RenderStructureHandler {
    private static StructureRenderData placingData;
    private static PlaceSchematicScreen schematicTools;

    public static void tick() {
        if (placingData == null) {
            return;
        }
        schematicTools.update();
    }

    public static void startRender(class_3499 structureTemplate, String name, String bpId) {
        if (placingData != null) {
            RenderStructureHandler.cancelRender();
        }
        placingData = new StructureRenderData(structureTemplate, name, bpId);
        schematicTools = new PlaceSchematicScreen();
        StructureRenderer.structures.add(placingData);
    }

    public static void cancelRender() {
        if (placingData == null) {
            return;
        }
        StructureRenderer.structures.remove(placingData);
        placingData = null;
    }

    public static void onConfirmHit() {
        if (placingData == null) {
            return;
        }
        placingData = null;
    }

    public static void setAnchor() {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.placingData.anchorPos = RaycastHelper.getLookingAt(RenderStructureHandler.placingData.distanceFromCameraCast, (class_1657)class_310.method_1551().field_1724, true).method_17777();
        schematicTools.setupManipulationTools();
    }

    public static void onZoom(boolean zoomIn) {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.placingData.distanceFromCameraCast = zoomIn ? (RenderStructureHandler.placingData.distanceFromCameraCast += 1.0) : (RenderStructureHandler.placingData.distanceFromCameraCast -= 1.0);
    }

    public static void positionClicked() {
        if (placingData == null) {
            return;
        }
        schematicTools.getSelectedElement().onClick();
    }

    public static void onRotateHit(boolean clockwise) {
        if (placingData == null) {
            return;
        }
        placingData.rotate(clockwise ? class_2470.field_11463 : class_2470.field_11465);
        RenderStructureHandler.placingData.lastRenderPos = null;
    }

    public static void offsetAnchor(class_2338 pos) {
        if (placingData == null || RenderStructureHandler.placingData.anchorPos == null) {
            return;
        }
        RenderStructureHandler.placingData.anchorPos = RenderStructureHandler.placingData.anchorPos.method_10081((class_2382)pos);
    }

    public static void onFlip() {
        if (placingData == null) {
            return;
        }
        placingData.flip();
        RenderStructureHandler.placingData.lastRenderPos = null;
    }

    public static void toolKeyHit(KeyEvent event) {
        if (placingData == null) {
            return;
        }
        boolean pressed = event.isDown();
        if (pressed && !RenderStructureHandler.schematicTools.focused) {
            RenderStructureHandler.schematicTools.focused = true;
        }
        if (!pressed && RenderStructureHandler.schematicTools.focused) {
            RenderStructureHandler.schematicTools.focused = false;
            schematicTools.method_25419();
        }
    }

    public static boolean mouseScrolled(double delta) {
        if (placingData == null) {
            return false;
        }
        return schematicTools.scroll(delta);
    }

    public static void renderInstructions(class_332 graphics, class_1041 window) {
        if (placingData == null) {
            return;
        }
        schematicTools.renderPassive(graphics, 0.0f);
    }

    public static void placeOnServer() {
        if (placingData == null) {
            return;
        }
        Services.PLATFORM.sendClientToServerPacket(new PlaceSchematicPacket(RenderStructureHandler.placingData.structureTemplate, RenderStructureHandler.placingData.structurePlaceSettings, RenderStructureHandler.placingData.anchorPos.method_10086(1)));
    }

    static {
        schematicTools = new PlaceSchematicScreen();
    }
}

