/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import fabric.com.hollingsworth.schematic.client.gui.BlockEntryRow;
import fabric.com.hollingsworth.schematic.client.gui.DownloadScreen;
import fabric.com.hollingsworth.schematic.client.gui.GuiImageButton;
import fabric.com.hollingsworth.schematic.client.gui.VerticalSlider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class BlockListScreen
extends BaseSchematicScreen {
    public class_437 previousScreen;
    List<DownloadScreen.BlockListEntry> entries;
    List<BlockEntryRow> rows = new ArrayList<BlockEntryRow>();
    int scroll = 0;
    VerticalSlider slider;

    public BlockListScreen(class_437 previousScreen, List<DownloadScreen.BlockListEntry> entries) {
        this.previousScreen = previousScreen;
        this.entries = entries;
        this.entries.sort((o1, o2) -> {
            if (o1.isMissing && !o2.isMissing) {
                return -1;
            }
            if (!o1.isMissing && o2.isMissing) {
                return 1;
            }
            return Integer.compare(o2.count, o1.count);
        });
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.method_37063(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, class_2960.method_60655((String)"blockprints", (String)"textures/gui/button_back.png"), b -> class_310.method_1551().method_1507(this.previousScreen)));
        this.updateList();
        int maxScroll = Math.max(0, this.entries.size() - 10);
        this.slider = this.method_37063(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, maxScroll, 1.0, 1, this::scrollChange));
    }

    public void scrollChange(int change) {
        this.scroll = change;
        this.updateList();
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.slider.method_25401(pMouseX, pMouseY, pScrollX, pScrollY)) {
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void updateList() {
        for (BlockEntryRow row : this.rows) {
            this.method_37066((class_364)row);
        }
        this.rows = new ArrayList<BlockEntryRow>();
        List<DownloadScreen.BlockListEntry> sliced = this.entries.subList(this.scroll, Math.min(this.scroll + 10, this.entries.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            DownloadScreen.BlockListEntry entry = sliced.get(i);
            BlockEntryRow row = new BlockEntryRow(this.bookLeft + 25, this.bookTop + 43 + i * 14, entry);
            this.rows.add(row);
            this.method_37063(row);
        }
    }

    @Override
    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(class_2960.method_60655((String)"blockprints", (String)"textures/gui/container_list_blocks.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"blockprints.block"), 30, 29, 0, false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"blockprints.qty"), 235, 29, 0, false);
    }
}

