/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.ClientConstants;
import fabric.com.hollingsworth.schematic.SchematicMod;
import fabric.com.hollingsworth.schematic.client.ClientData;
import fabric.com.hollingsworth.schematic.client.RenderStructureHandler;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PlaceSchematicScreen
extends class_437 {
    public static PlaceTool placeTool = new PlaceTool();
    public static RotateTool rotateTool = new RotateTool();
    public static MoveHorizontalTool moveHorizontalTool = new MoveHorizontalTool();
    public static MoveVerticalTool moveVerticalTool = new MoveVerticalTool();
    public static ConfirmTool confirmTool = new ConfirmTool();
    public static PrintTool printTool = new PrintTool();
    public static DeleteTool deleteTool = new DeleteTool();
    public static MirrorTool mirrorTool = new MirrorTool();
    public final String holdToFocus = "blockprints.gui.toolmenu.focusKey";
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;
    public List<ToolType> tools = new ArrayList<ToolType>();

    public PlaceSchematicScreen() {
        super((class_2561)class_2561.method_43470((String)"Tool Selection"));
        this.field_22787 = class_310.method_1551();
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.h = 34;
        this.tools.add(new PlaceTool());
    }

    public void setupManipulationTools() {
        this.tools.clear();
        this.tools.add(moveHorizontalTool);
        this.tools.add(moveVerticalTool);
        this.tools.add(rotateTool);
        this.tools.add(confirmTool);
        if (class_310.method_1551().field_1724.method_7337() && ClientConstants.blockprintsServerside) {
            this.tools.add(printTool);
        }
        this.tools.add(deleteTool);
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains(tool)) {
            return;
        }
        this.selection = this.tools.indexOf(tool);
    }

    public ToolType getSelectedElement() {
        return this.tools.get(this.selection);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        this.w = Math.max(this.tools.size() * 50 + 32, 220);
        class_4587 matrixStack = graphics.method_51448();
        class_1041 mainWindow = this.field_22787.method_22683();
        if (!this.initialized) {
            this.method_25423(this.field_22787, mainWindow.method_4486(), mainWindow.method_4502());
        }
        int x = (mainWindow.method_4486() - this.w) / 2 + 14;
        int y = mainWindow.method_4502() - this.h - 34;
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        graphics.method_25290(SchematicMod.prefix("textures/gui/hud_background.png"), x - 15, y, 0.0f, 0.0f, this.w, this.h, 16, 16);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<class_2561> toolTip = this.tools.get(this.selection).getDescription();
        if (toolTipAlpha > 0.25f) {
            graphics.method_25290(SchematicMod.prefix("textures/gui/hud_background.png"), x - 15, y + 16, 0.0f, 0.0f, this.w, this.h, 16, 16);
            if (!toolTip.isEmpty()) {
                GuiUtils.drawOutlinedText(this.field_22787.field_1772, graphics, toolTip.get(0), x - 10, y + 38);
            }
            if (toolTip.size() > 1) {
                GuiUtils.drawOutlinedText(this.field_22787.field_1772, graphics, toolTip.get(1), x - 10, y + 50);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = ClientData.TOOL_MENU.method_16007().getString();
            int width = this.field_22787.method_22683().method_4486();
            if (!this.focused) {
                GuiUtils.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43469((String)"blockprints.gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10);
            } else {
                GuiUtils.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43471((String)"blockprints.scroll"), width / 2, y - 10);
            }
        } else {
            GuiUtils.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, (class_2561)class_2561.method_43471((String)"blockprints.place_description"), this.field_22789 / 2, y - 10);
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            matrixStack.method_22903();
            if (i == this.selection) {
                matrixStack.method_46416(0.0f, -10.0f, 0.0f);
                GuiUtils.drawCenteredOutlinedText(this.field_22787.field_1772, graphics, this.tools.get(i).getDisplayName(), x + i * 50 + 26, y + 28);
            }
            class_2960 icon = this.tools.get(i).getIcon();
            graphics.method_25290(icon, x + i * 50 + 16, y + 11, 0.0f, 0.0f, 16, 16, 16, 16);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public boolean scroll(double delta) {
        if (this.focused) {
            this.cycle((int)delta);
            return true;
        }
        if (PlaceSchematicScreen.method_25441()) {
            return this.tools.get(this.selection).handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void method_25419() {
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
    }

    public static class PlaceTool
    extends ToolType {
        public PlaceTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.place_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_place.png"));
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            RenderStructureHandler.setAnchor();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onZoom(delta > 0.0);
            return true;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        public MoveHorizontalTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.move_horizontal_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_horizontal.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            class_2350 direction = class_310.method_1551().field_1724.method_58149();
            class_2338 offset = new class_2338((int)delta * direction.method_10148(), 0, (int)delta * direction.method_10165());
            RenderStructureHandler.offsetAnchor(offset);
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        public MoveVerticalTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.move_vertical_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_vertical.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.offsetAnchor(new class_2338(0, (int)delta, 0));
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.move_vertical_description"));
            return list;
        }
    }

    public static class RotateTool
    extends ToolType {
        public RotateTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.rotate_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_rotate.png"));
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onRotateHit(delta > 0.0);
            return true;
        }
    }

    public static class ConfirmTool
    extends ToolType {
        public ConfirmTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.confirm_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_confirm.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.onConfirmHit();
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.confirm_description"));
            return list;
        }
    }

    public static class PrintTool
    extends ToolType {
        public PrintTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.print_tool"), SchematicMod.prefix("textures/gui/visualizer_print.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.placeOnServer();
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.print_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType {
        public DeleteTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.delete_tool"), SchematicMod.prefix("textures/gui/visualizer_trash.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.cancelRender();
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.delete_description"));
            return list;
        }
    }

    public static abstract class ToolType {
        class_2561 name;
        class_2960 icon;

        public ToolType(class_2561 name, class_2960 icon) {
            this.name = name;
            this.icon = icon;
        }

        public void onClick() {
        }

        public class_2561 getDisplayName() {
            return this.name;
        }

        abstract List<class_2561> getDescription();

        public class_2960 getIcon() {
            return this.icon;
        }

        public boolean handleMouseWheel(double delta) {
            return false;
        }
    }

    public static class MirrorTool
    extends ToolType {
        public MirrorTool() {
            super((class_2561)class_2561.method_43471((String)"blockprints.mirror_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_mirror.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onFlip();
            return true;
        }

        @Override
        List<class_2561> getDescription() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add((class_2561)class_2561.method_43471((String)"blockprints.mirror_description"));
            return list;
        }
    }
}

