/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.client.gui.ModScreen;
import fabric.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import fabric.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import fabric.com.hollingsworth.schematic.client.renderer.StatePos;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import fabric.com.hollingsworth.schematic.export.CameraSettings;
import fabric.com.hollingsworth.schematic.export.LytSize;
import fabric.com.hollingsworth.schematic.export.OffScreenRenderer;
import fabric.com.hollingsworth.schematic.export.Scene;
import fabric.com.hollingsworth.schematic.export.WrappedScene;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ScenePreview
extends class_339 {
    private int yaw = 225;
    private int pitch = 30;
    private int roll;
    public WrappedScene wrappedScene;
    public Scene scene;
    public OffScreenRenderer renderer;
    class_3499 template;
    FakeRenderingWorld fakeRenderingWorld;
    StructureRenderData cachedRender;
    boolean doSort;
    int sortDebounce;

    public ScenePreview(int x, int y, int width, int height, Scene scene, WrappedScene wrappedScene, class_3499 template) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.wrappedScene = wrappedScene;
        this.scene = scene;
        this.cachedRender = new StructureRenderData(template, null, null);
        StructureRenderer.generateRender(this.cachedRender, (class_1937)class_310.method_1551().field_1687, class_2338.field_10980, 1.0f, new class_243(0.0, 0.0, 0.0));
        this.scheduleSort();
    }

    public void updateSceneTexture() {
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        float scale = (float)class_310.method_1551().method_22683().method_4495();
        if (prefSize.width() > 0 && prefSize.height() > 0) {
            int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
            int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
            if (this.renderer == null || this.renderer.width != renderWidth || this.renderer.height != renderHeight) {
                if (this.renderer != null) {
                    this.renderer.close();
                }
                this.renderer = new OffScreenRenderer(renderWidth, renderHeight);
            }
            this.renderer.renderToTexture(this::renderTarget);
        }
    }

    public void renderTarget() {
        this.wrappedScene.renderToCurrentTarget(this.wrappedScene.getPreferredSize());
    }

    public void removed() {
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
    }

    public void tick() {
        if (this.doSort) {
            if (this.sortDebounce > 0) {
                --this.sortDebounce;
            } else {
                this.doSort = false;
                ScenePreview.sortAll(this.cachedRender, new class_243(0.0, 0.0, 0.0));
            }
        }
    }

    protected void method_48579(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int previewX = this.field_22760;
        int previewY = this.field_22761;
        float scale = (float)class_310.method_1551().method_22683().method_4495();
        boolean doOldRender = false;
        if (doOldRender) {
            this.updateSceneTexture();
            if (this.renderer != null) {
                int imageWidth = this.renderer.width;
                int imageHeight = this.renderer.height;
                LytSize origDim = new LytSize(imageWidth, imageHeight);
                LytSize boundary = new LytSize(this.field_22758, this.field_22759);
                LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
                int x = previewX + 71;
                int y = previewY + 55;
                this.innerBlit(graphics.method_51448(), this.renderer, x -= newDim.width() / 2, x + newDim.width(), y -= newDim.height() / 2, y + newDim.height(), 0);
            }
            return;
        }
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize size = this.wrappedScene.getPreferredSize();
        this.scene.getCameraSettings().setViewportSize(size);
        CameraSettings cameraSettings = this.scene.getCameraSettings();
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
        int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
        LytSize origDim = new LytSize(renderWidth, renderHeight);
        LytSize boundary = new LytSize(this.field_22758, this.field_22759);
        LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
        int x = previewX + 71;
        int y = previewY + 71;
        RenderSystem.viewport((int)((int)((float)(x -= newDim.width() / 2) * scale)), (int)((int)((float)(y -= newDim.height() / 2) * scale)), (int)((int)((float)newDim.width() * scale)), (int)((int)((float)newDim.height() * scale)));
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_34425(viewMatrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        RenderSystem.runAsFancy(() -> this.drawRenderScreen(poseStack, (class_1657)class_310.method_1551().field_1724, this.cachedRender.statePosCache));
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)class_310.method_1551().method_22683().method_4489(), (int)class_310.method_1551().method_22683().method_4506());
        RenderSystem.restoreProjectionMatrix();
        ModScreen.blitRect(graphics.method_51448(), x + 121, y + 3, 0.0f, 0.0f, 17.0f, 17.0f, 17, 17, class_2960.method_60655((String)"blockprints", (String)"textures/gui/gimbal/gimbal_cardinal.png"), 150);
    }

    void innerBlit(class_4587 pose, OffScreenRenderer osr, int x1, int x2, int y1, int y2, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (int)osr.fb.method_30277());
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(1.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(1.0f, 1.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
    }

    public static LytSize getScaledDimension(LytSize imgSize, LytSize boundary) {
        int original_width = imgSize.width();
        int original_height = imgSize.height();
        int bound_width = boundary.width();
        int bound_height = boundary.height();
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new LytSize(new_width, new_height);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public void method_25354(class_1144 $$0) {
    }

    public void drawRenderScreen(class_4587 matrix, class_1657 player, ArrayList<StatePos> statePosCache) {
        class_4597.class_4598 buffersource = class_310.method_1551().method_22940().method_23000();
        ArrayList<class_1921> drawSet = new ArrayList<class_1921>();
        drawSet.add(class_1921.method_23577());
        drawSet.add(class_1921.method_23581());
        drawSet.add(class_1921.method_23579());
        drawSet.add(class_1921.method_23583());
        drawSet.add(class_1921.method_29997());
        try {
            Iterator iterator = drawSet.iterator();
            while (iterator.hasNext()) {
                class_1921 renderType;
                class_1921 drawRenderType = renderType = (class_1921)iterator.next();
                class_291 vertexBuffer = this.cachedRender.vertexBuffers.get(renderType);
                if (vertexBuffer.method_34435() == null) continue;
                drawRenderType.method_23516();
                vertexBuffer.method_1353();
                vertexBuffer.method_34427(matrix.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                class_291.method_1354();
                drawRenderType.method_23518();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.method_22903();
        matrix.method_34426();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((class_4597)buffersource, 1.0f);
        if (this.fakeRenderingWorld == null) {
            this.fakeRenderingWorld = new FakeRenderingWorld((class_1937)class_310.method_1551().field_1687, statePosCache, class_2338.field_10980);
        }
        for (StatePos pos : statePosCache) {
            if (pos.state.method_26215() || StructureRenderer.isModelRender(pos.state)) continue;
            matrix.method_22903();
            matrix.method_46416((float)pos.pos.method_10263(), (float)pos.pos.method_10264(), (float)pos.pos.method_10260());
            class_824 blockEntityRenderer = class_310.method_1551().method_31975();
            class_2586 blockEntity = this.fakeRenderingWorld.method_8321(pos.pos);
            if (blockEntity != null) {
                class_827 renderer = blockEntityRenderer.method_3550(blockEntity);
                try {
                    renderer.method_3569(blockEntity, 0.0f, matrix, (class_4597)multiplyAlphaRenderTypeBuffer, 0xF00000, class_4608.field_21444);
                }
                catch (Exception exception) {}
            } else {
                try {
                    DireRenderMethods.renderBETransparent(this.fakeRenderingWorld.method_8320(pos.pos), matrix, (class_4597)buffersource, 0xF00000, 655360, 1.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            matrix.method_22909();
        }
        matrix.method_22909();
        buffersource.method_37104();
    }

    public static void sortAll(StructureRenderData data, class_243 projectedView) {
        for (Map.Entry<class_1921, class_9801.class_9802> entry : data.sortStates.entrySet()) {
            class_1921 renderType = entry.getKey();
            class_9799.class_9800 renderedBuffer = ScenePreview.sort(data, projectedView, renderType);
            class_291 vertexBuffer = data.vertexBuffers.get(renderType);
            vertexBuffer.method_1353();
            vertexBuffer.method_60829(renderedBuffer);
            class_291.method_1354();
        }
    }

    public static class_9799.class_9800 sort(StructureRenderData data, class_243 projectedView, class_1921 renderType) {
        class_243 inverted = projectedView.method_1021(-1.0);
        class_243 subtracted = projectedView.method_1019(inverted.method_1029().method_1021(0.1));
        Vector3f sortPos = new Vector3f((float)(-subtracted.field_1352), (float)(-subtracted.field_1351), (float)(-subtracted.field_1350));
        return data.sortStates.get(renderType).method_60824(data.getByteBuffer(renderType), class_8251.method_49907(v -> -sortPos.distanceSquared((Vector3fc)v)));
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
        this.scheduleSort();
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = pitch;
        this.scheduleSort();
    }

    public int getRoll() {
        return this.roll;
    }

    public void setRoll(int roll) {
        this.roll = roll;
        this.scheduleSort();
    }

    private void scheduleSort() {
        this.doSort = true;
        this.sortDebounce = 20;
    }
}

