/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.client.RaycastHelper;
import fabric.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import fabric.com.hollingsworth.schematic.client.renderer.DireRenderTypes;
import fabric.com.hollingsworth.schematic.client.renderer.DireVertexConsumer;
import fabric.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import fabric.com.hollingsworth.schematic.client.renderer.RenderFluidBlock;
import fabric.com.hollingsworth.schematic.client.renderer.StatePos;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.common.util.Color;
import fabric.com.hollingsworth.schematic.common.util.DimPos;
import fabric.com.hollingsworth.schematic.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StructureRenderer {
    public static ArrayList<StructureRenderData> structures = new ArrayList();

    public static void buildRender(StructureRenderData data, class_4587 poseStack, class_1657 player) {
        class_2338 renderPos;
        class_3965 lookingAt = RaycastHelper.getLookingAt(data.distanceFromCameraCast, player, true);
        class_2338 class_23382 = renderPos = data.anchorPos == null ? lookingAt.method_17777() : data.anchorPos;
        if (renderPos == null) {
            return;
        }
        renderPos = renderPos.method_10084();
        DimPos boundTo = new DimPos((class_5321<class_1937>)player.field_6002.method_27983(), renderPos);
        if (boundTo != null && boundTo.levelKey().equals((Object)player.method_37908().method_27983())) {
            StructureRenderer.drawBoundBox(data, poseStack, boundTo.pos());
        }
        if (StructureRenderer.shouldUpdateRender(data, renderPos = renderPos.method_10084())) {
            StructureRenderer.generateRender(data, player.method_37908(), renderPos, 0.5f);
            data.lastRenderPos = renderPos;
        }
    }

    public static boolean shouldUpdateRender(StructureRenderData data, class_2338 renderPos) {
        return data.lastRenderPos == null || !data.lastRenderPos.equals((Object)renderPos);
    }

    public static void clearByteBuffers(StructureRenderData data) {
        for (Map.Entry<class_1921, class_9799> entry : data.builders.entrySet()) {
            entry.getValue().method_60809();
        }
        data.bufferBuilders.clear();
        data.sortStates.clear();
        data.meshDatas.clear();
    }

    public static void generateRender(StructureRenderData data, class_1937 level, class_2338 renderPos, float transparency) {
        StructureRenderer.generateRender(data, level, renderPos, transparency, class_310.method_1551().field_1773.method_19418().method_19326());
    }

    public static void generateRender(StructureRenderData data, class_1937 level, class_2338 renderPos, float transparency, class_243 cameraPosition) {
        class_287 builder;
        ArrayList<StatePos> statePosCache = data.statePosCache;
        Map<class_1921, class_291> vertexBuffers = data.vertexBuffers;
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        data.fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        class_4587 matrix = new class_4587();
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 modelBlockRenderer = dispatcher.method_3350();
        class_5819 random = class_5819.method_43047();
        StructureRenderer.clearByteBuffers(data);
        for (StatePos pos : statePosCache) {
            class_2680 renderState = data.fakeRenderingWorld.getBlockStateWithoutReal(pos.pos);
            if (renderState.method_26215() || !StructureRenderer.isModelRender(pos.state) && pos.state.method_26227().method_15769()) continue;
            class_1087 ibakedmodel = dispatcher.method_3349(renderState);
            matrix.method_22903();
            matrix.method_46416((float)pos.pos.method_10263(), (float)pos.pos.method_10264(), (float)pos.pos.method_10260());
            for (class_1921 renderType : Services.PLATFORM.getRenderTypes(ibakedmodel, renderState, random)) {
                if (renderType.equals(class_1921.method_23581()) && renderState.method_26218((class_1922)level, pos.pos.method_10081((class_2382)renderPos)).equals(class_259.method_1077())) {
                    renderType = class_1921.method_23583();
                }
                builder = data.bufferBuilders.computeIfAbsent(renderType, rt -> new class_287(data.getByteBuffer((class_1921)rt), rt.method_23033(), rt.method_23031()));
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((class_4588)builder, transparency);
                if (renderState.method_26227().method_15769()) {
                    try {
                        modelBlockRenderer.method_3374((class_1920)data.fakeRenderingWorld, ibakedmodel, renderState, pos.pos.method_10081((class_2382)renderPos).method_10086(255), matrix, (class_4588)direVertexConsumer, false, random, renderState.method_26190(pos.pos.method_10081((class_2382)renderPos)), class_4608.field_21444);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    RenderFluidBlock.renderFluidBlock(renderState, level, pos.pos.method_10081((class_2382)renderPos).method_10086(255), matrix, direVertexConsumer, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            matrix.method_22909();
        }
        class_243 subtracted = cameraPosition.method_1023((double)renderPos.method_10263(), (double)renderPos.method_10264(), (double)renderPos.method_10260());
        Vector3f sortPos = new Vector3f((float)subtracted.field_1352, (float)subtracted.field_1351, (float)subtracted.field_1350);
        for (Map.Entry<class_1921, class_287> entry : data.bufferBuilders.entrySet()) {
            class_1921 renderType = entry.getKey();
            class_9799 byteBufferBuilder = data.getByteBuffer(renderType);
            builder = entry.getValue();
            Map<class_1921, class_9801> meshDatas = data.meshDatas;
            if (meshDatas.containsKey(renderType) && meshDatas.get(renderType) != null) {
                meshDatas.get(renderType).close();
            }
            meshDatas.put(renderType, builder.method_60794());
            if (!meshDatas.containsKey(renderType) || meshDatas.get(renderType) == null) continue;
            data.sortStates.put(renderType, meshDatas.get(renderType).method_60819(byteBufferBuilder, class_8251.method_49907(v -> -sortPos.distanceSquared((Vector3fc)v))));
            class_291 vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.method_1353();
            vertexBuffer.method_1352(meshDatas.get(renderType));
            class_291.method_1354();
        }
    }

    public static void drawBoundBox(StructureRenderData data, class_4587 matrix, class_2338 blockPos) {
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        matrix.method_22903();
        matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
        Color color = Color.BLUE;
        class_3341 boundingBox = data.boundingBox;
        if (boundingBox != null) {
            class_2338 min = new class_2338(boundingBox.method_35415(), boundingBox.method_35416(), boundingBox.method_35417());
            class_2338 max = new class_2338(boundingBox.method_35418(), boundingBox.method_35419(), boundingBox.method_35420());
            min = min.method_10081((class_2382)blockPos);
            max = max.method_10081((class_2382)blockPos);
            DireRenderMethods.renderCopy(matrix, min, max, color);
        }
        matrix.method_22909();
    }

    public static boolean isModelRender(class_2680 state) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_1087 ibakedmodel = dispatcher.method_3349(state);
        for (class_2350 direction : class_2350.values()) {
            if (!ibakedmodel.method_4707(state, direction, class_5819.method_43047()).isEmpty()) {
                return true;
            }
            if (ibakedmodel.method_4707(state, null, class_5819.method_43047()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(StructureRenderData data, class_4587 poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, class_1657 player) {
        if (data.vertexBuffers == null) {
            return;
        }
        class_2338 anchorPos = data.anchorPos;
        class_4597.class_4598 buffersource = class_310.method_1551().method_22940().method_23000();
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        class_3965 lookingAt = RaycastHelper.getLookingAt(data.distanceFromCameraCast, player, true);
        class_2338 renderPos = anchorPos == null ? lookingAt.method_17777() : anchorPos;
        class_2680 lookingAtState = player.method_37908().method_8320(renderPos);
        if (lookingAtState.method_26215() && anchorPos == null) {
            return;
        }
        renderPos = renderPos.method_10084();
        if (data.sortCounter > 20) {
            StructureRenderer.sortAll(data, renderPos);
            data.sortCounter = 0;
        } else {
            ++data.sortCounter;
        }
        class_4587 matrix = poseStack;
        matrix.method_22903();
        matrix.method_34425(modelViewMatrix);
        matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
        matrix.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
        ArrayList<class_1921> drawSet = new ArrayList<class_1921>();
        drawSet.add(class_1921.method_23577());
        drawSet.add(class_1921.method_23581());
        drawSet.add(class_1921.method_23579());
        drawSet.add(class_1921.method_23583());
        drawSet.add(class_1921.method_29997());
        try {
            for (class_1921 renderType : drawSet) {
                class_1921 drawRenderType = renderType.equals(class_1921.method_23581()) ? DireRenderTypes.RenderBlock : class_1921.method_23583();
                class_291 vertexBuffer = data.vertexBuffers.get(renderType);
                if (vertexBuffer.method_34435() == null) continue;
                drawRenderType.method_23516();
                vertexBuffer.method_1353();
                vertexBuffer.method_34427(matrix.method_23760().method_23761(), new Matrix4f((Matrix4fc)projectionMatrix), RenderSystem.getShader());
                class_291.method_1354();
                drawRenderType.method_23518();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrix.method_22909();
        class_776 dispatcher = class_310.method_1551().method_1541();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((class_4597)buffersource, 0.5f);
        data.fakeRenderingWorld = new FakeRenderingWorld(player.method_37908(), data.statePosCache, renderPos);
        for (StatePos pos : data.statePosCache) {
            if (pos.state.method_26215() || StructureRenderer.isModelRender(pos.state)) continue;
            matrix.method_22903();
            matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
            matrix.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
            matrix.method_46416((float)pos.pos.method_10263(), (float)pos.pos.method_10264(), (float)pos.pos.method_10260());
            class_824 blockEntityRenderer = class_310.method_1551().method_31975();
            class_2586 blockEntity = data.fakeRenderingWorld.method_8321(pos.pos);
            if (blockEntity != null) {
                blockEntityRenderer.method_3555(blockEntity, 0.0f, matrix, (class_4597)multiplyAlphaRenderTypeBuffer);
            } else {
                DireRenderMethods.renderBETransparent(data.fakeRenderingWorld.method_8320(pos.pos), matrix, (class_4597)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.method_22909();
        }
    }

    public static void sortAll(StructureRenderData data, class_2338 lookingAt) {
        for (Map.Entry<class_1921, class_9801.class_9802> entry : data.sortStates.entrySet()) {
            class_1921 renderType = entry.getKey();
            class_9799.class_9800 renderedBuffer = StructureRenderer.sort(data, lookingAt, renderType);
            class_291 vertexBuffer = data.vertexBuffers.get(renderType);
            vertexBuffer.method_1353();
            vertexBuffer.method_60829(renderedBuffer);
            class_291.method_1354();
        }
    }

    public static class_9799.class_9800 sort(StructureRenderData data, class_2338 lookingAt, class_1921 renderType) {
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 subtracted = projectedView.method_1023((double)lookingAt.method_10263(), (double)lookingAt.method_10264(), (double)lookingAt.method_10260());
        Vector3f sortPos = new Vector3f((float)subtracted.field_1352, (float)subtracted.field_1351, (float)subtracted.field_1350);
        return data.sortStates.get(renderType).method_60824(data.getByteBuffer(renderType), class_8251.method_49907(v -> -sortPos.distanceSquared((Vector3fc)v)));
    }
}

