/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Collection;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OffScreenRenderer
implements AutoCloseable {
    private final class_1011 nativeImage;
    public final class_6367 fb;
    public final int width;
    public final int height;
    private final class_1044 texture = new class_1044(){

        public int method_4624() {
            return OffScreenRenderer.this.fb.method_30277();
        }

        public void method_4625(class_3300 resourceManager) throws IOException {
        }
    };

    public OffScreenRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        this.nativeImage = new class_1011(width, height, true);
        this.fb = new class_6367(width, height, true, true);
        this.fb.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.fb.method_1230(true);
    }

    public class_1044 getTexture() {
        return this.texture;
    }

    public void renderToTexture(Runnable r) {
        RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        int currentBuffer = GlStateManager.getBoundFramebuffer();
        this.fb.method_1235(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.method_1240();
        GlStateManager._glBindFramebuffer((int)36160, (int)currentBuffer);
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null) {
            class_1041 window = minecraft.method_22683();
            RenderSystem.viewport((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
        }
    }

    @Override
    public void close() {
        this.nativeImage.close();
        this.fb.method_1238();
    }

    public byte[] captureAsPng(Runnable r) {
        this.renderToBuffer(r);
        try {
            return this.nativeImage.method_24036();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode image as PNG", e);
        }
    }

    public boolean isAnimated(Collection<class_1058> sprites) {
        return sprites.stream().anyMatch(s -> s.method_45851().field_40541 != null);
    }

    private void renderToBuffer(Runnable r) {
        this.fb.method_1235(true);
        GlStateManager._clear((int)16640, (boolean)false);
        r.run();
        this.fb.method_1240();
        this.fb.method_35610();
        this.nativeImage.method_4327(0, false);
        this.nativeImage.method_4319();
        this.fb.method_1242();
    }

    private static Matrix4f createViewMatrix(Vector3f eyePos, Vector3f lookAt) {
        Vector3f dir = new Vector3f((Vector3fc)lookAt);
        dir.sub((Vector3fc)eyePos);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        dir.normalize();
        Vector3f right = new Vector3f((Vector3fc)dir);
        right.cross((Vector3fc)up);
        right.normalize();
        up = new Vector3f((Vector3fc)right);
        up.cross((Vector3fc)dir);
        up.normalize();
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.setTransposed(FloatBuffer.wrap(new float[]{right.x(), right.y(), right.z(), 0.0f, up.x(), up.y(), up.z(), 0.0f, -dir.x(), -dir.y(), -dir.z(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}));
        viewMatrix.translate(-eyePos.x(), -eyePos.y(), -eyePos.z());
        return viewMatrix;
    }
}

