/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fabric.com.hollingsworth.schematic.client.renderer.StatePos;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6826;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public class Template {
    public String name;
    public String statePosArrayList;
    public Map<String, Integer> requiredItems = new Object2IntOpenHashMap();
    private static final ImmutableList<class_2769<?>> DENY_PROPERTIES = ImmutableList.of((Object)class_2741.field_12521, (Object)class_2741.field_12556, (Object)class_2741.field_12497, (Object)class_2741.field_37654, (Object)class_2741.field_12482, (Object)class_2741.field_12550, (Object)class_2741.field_12498, (Object)class_2741.field_12517, (Object)class_2320.field_10929, (Object)class_2741.field_12508, (Object)class_2741.field_12548, (Object)class_2741.field_12544, (Object[])new class_2769[]{class_2741.field_17393, class_2741.field_12537, class_2741.field_12549});

    public Template(String name, class_2338 start, class_2338 end) {
        this.name = name;
        ArrayList<StatePos> statePosArrayList = Template.listForDire(start, end, (class_1937)class_310.method_1551().field_1687);
        this.statePosArrayList = Template.statePosListToNBTMapArray(statePosArrayList).toString();
        Map<ItemStackKey, Integer> requiredItemsTemp = StatePos.getItemList(statePosArrayList);
        for (Map.Entry<ItemStackKey, Integer> entry : requiredItemsTemp.entrySet()) {
            if (entry.getKey().getStack().method_7960()) continue;
            class_6880<class_1792> item = entry.getKey().item;
            class_2960 registryName = class_7923.field_41178.method_10221((Object)((class_1792)item.comp_349()));
            this.requiredItems.put(registryName.toString(), entry.getValue());
        }
    }

    public String toJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public static ArrayList<StatePos> listForDire(class_2338 startRaw, class_2338 endRaw, class_1937 level) {
        ArrayList<StatePos> list = new ArrayList<StatePos>();
        class_238 area = class_238.method_54784((class_2338)startRaw, (class_2338)endRaw);
        class_2338.method_29715((class_238)area).map(class_2338::method_10062).forEach(pos -> {
            if (Template.validStateForDire(level.method_8320(pos), level, pos)) {
                list.add(new StatePos(Template.cleanBlockState(level.method_8320(pos)), pos.method_10059((class_2382)startRaw)));
            } else {
                list.add(new StatePos(class_2246.field_10124.method_9564(), pos.method_10059((class_2382)startRaw)));
            }
        });
        return list;
    }

    public static class_2487 statePosListToNBTMapArray(ArrayList<StatePos> list) {
        class_2487 tag = new class_2487();
        ArrayList<class_2680> blockStateMap = StatePos.getBlockStateMap(list);
        class_2499 blockStateMapList = StatePos.getBlockStateNBT(blockStateMap);
        int[] blocklist = new int[list.size()];
        int[] counter = new int[]{0};
        class_2338 start = list.get((int)0).pos;
        class_2338 end = list.get((int)(list.size() - 1)).pos;
        class_238 aabb = new class_238(new class_243((double)start.method_10263(), (double)start.method_10264(), (double)start.method_10260()), new class_243((double)end.method_10263(), (double)end.method_10264(), (double)end.method_10260()));
        Map<class_2338, class_2680> blockStateByPos = list.stream().collect(Collectors.toMap(e -> e.pos, e -> e.state));
        class_2338.method_29715((class_238)aabb).map(class_2338::method_10062).forEach(pos -> {
            class_2680 blockState = (class_2680)blockStateByPos.get(pos);
            int n = counter[0];
            counter[0] = n + 1;
            blocklist[n] = blockStateMap.indexOf(blockState);
        });
        tag.method_10566("startpos", class_2512.method_10692((class_2338)start));
        tag.method_10566("endpos", class_2512.method_10692((class_2338)end));
        tag.method_10566("blockstatemap", (class_2520)blockStateMapList);
        tag.method_10539("statelist", blocklist);
        return tag;
    }

    public static class_2680 cleanBlockState(class_2680 sourceState) {
        class_2680 placeState = sourceState.method_26204().method_9564();
        for (class_2769 prop : sourceState.method_28501()) {
            if (DENY_PROPERTIES.contains((Object)prop)) continue;
            placeState = Template.applyProperty(placeState, sourceState, prop);
        }
        return placeState;
    }

    private static <T extends Comparable<T>> class_2680 applyProperty(class_2680 state, class_2680 from, class_2769<T> prop) {
        return (class_2680)state.method_11657(prop, from.method_11654(prop));
    }

    public static boolean validStateForDire(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        if (blockState.method_26214((class_1922)level, blockPos) < 0.0f) {
            return false;
        }
        return blockState.method_26227().method_15769() || blockState.method_26227().method_15771();
    }

    public static ArrayList<StatePos> statePosListFromNBTMapArray(class_2487 tag) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        if (!tag.method_10545("blockstatemap") || !tag.method_10545("statelist")) {
            return statePosList;
        }
        ArrayList<class_2680> blockStateMap = StatePos.getBlockStateMapFromNBT(tag.method_10554("blockstatemap", 10));
        class_2338 start = Template.readBlockPos(tag, "startpos");
        class_2338 end = Template.readBlockPos(tag, "endpos");
        class_238 aabb = Template.aabbFromBlockPos(start, end);
        int[] blocklist = tag.method_10561("statelist");
        int[] counter = new int[]{0};
        class_2338.method_29715((class_238)aabb).map(class_2338::method_10062).forEach(pos -> {
            int n = counter[0];
            counter[0] = n + 1;
            int blockStateLookup = blocklist[n];
            class_2680 blockState = (class_2680)blockStateMap.get(blockStateLookup);
            statePosList.add(new StatePos(blockState, (class_2338)pos));
        });
        return statePosList;
    }

    public static class_2338 readBlockPos(class_2487 compoundTag, String pKey) {
        if (!compoundTag.method_10545(pKey)) {
            return class_2338.field_10980;
        }
        class_2487 tag = compoundTag.method_10562(pKey);
        return new class_2338(tag.method_10550("X"), tag.method_10550("Y"), tag.method_10550("Z"));
    }

    public static class_243 blockPosToVec3(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static class_238 aabbFromBlockPos(class_2338 start, class_2338 end) {
        return new class_238(Template.blockPosToVec3(start), Template.blockPosToVec3(end));
    }

    public static class_2487 readCompressed(InputStream pZippedStream, class_2505 pAccounter) throws IOException {
        class_2487 compoundtag;
        try (DataInputStream datainputstream = new DataInputStream((InputStream)new class_6826((InputStream)new GZIPInputStream(pZippedStream)));){
            compoundtag = class_2507.method_10625((DataInput)datainputstream, (class_2505)pAccounter);
        }
        return compoundtag;
    }

    public static class ItemStackKey {
        public final class_6880<class_1792> item;
        public final class_9326 dataComponents;
        private final int hash;

        public ItemStackKey(class_1799 stack, boolean compareNBT) {
            this.item = stack.method_41409();
            this.dataComponents = compareNBT ? stack.method_57380() : class_9326.field_49588;
            this.hash = Objects.hash(this.item, this.dataComponents);
        }

        public class_1799 getStack() {
            return new class_1799(this.item, 1, this.dataComponents);
        }

        public class_1799 getStack(int amt) {
            return new class_1799(this.item, amt, this.dataComponents);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemStackKey) {
                return ((ItemStackKey)obj).item == this.item && Objects.equals(((ItemStackKey)obj).dataComponents, this.dataComponents);
            }
            return false;
        }
    }
}

