/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export;

import fabric.com.hollingsworth.schematic.export.GuidebookLevelRenderer;
import fabric.com.hollingsworth.schematic.export.LytSize;
import fabric.com.hollingsworth.schematic.export.OffScreenRenderer;
import fabric.com.hollingsworth.schematic.export.SavedCameraSettings;
import fabric.com.hollingsworth.schematic.export.Scene;
import fabric.com.hollingsworth.schematic.export.level.FakeForwardingServerLevel;
import net.minecraft.class_1011;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class WrappedScene {
    @Nullable
    public Scene scene;
    public final Viewport viewport = new Viewport();
    private SavedCameraSettings initialCameraSettings = new SavedCameraSettings();

    public void setScene(@Nullable Scene scene) {
        this.scene = scene;
        this.initialCameraSettings = scene != null ? scene.getCameraSettings().save() : new SavedCameraSettings();
    }

    public void placeStructure(class_3499 structureTemplate) {
        class_6575 random = new class_6575(0L);
        class_3492 settings = new class_3492();
        settings.method_15133(true);
        structureTemplate.method_15172((class_5425)new FakeForwardingServerLevel((class_1936)this.scene.getLevel()), class_2338.field_10980, class_2338.field_10980, settings, (class_5819)random, 0);
    }

    public ImageExport exportAsPng(float scale) {
        if (this.scene == null) {
            return null;
        }
        LytSize prefSize = this.viewport.getPreferredSize();
        LytSize scaledSize = this.getSizeForExport(scale);
        if (scaledSize == null) {
            return null;
        }
        return this.exportAsPng(scaledSize.width(), scaledSize.height(), prefSize);
    }

    public ImageExport exportPreviewPng() {
        if (this.scene == null) {
            return null;
        }
        LytSize rescaledSize = this.getSizeForPreview();
        if (rescaledSize == null) {
            return null;
        }
        return this.exportAsPng(rescaledSize.width(), rescaledSize.height(), this.viewport.getPreferredSize());
    }

    public ImageExport exportAsPng(int width, int height, LytSize viewportSize) {
        try (OffScreenRenderer osr = new OffScreenRenderer(width, height);){
            byte[] image = osr.captureAsPng(() -> {
                GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
                this.scene.getCameraSettings().setViewportSize(viewportSize);
                renderer.render(this.scene.getLevel(), this.scene.getCameraSettings());
            });
            ImageExport imageExport = new ImageExport(new LytSize(width, height), image);
            return imageExport;
        }
    }

    @Nullable
    public LytSize getSizeForExport(float scale) {
        LytSize prefSize = this.viewport.getPreferredSize();
        if (prefSize.width() <= 0 || prefSize.height() <= 0) {
            return null;
        }
        int width = (int)Math.max(1.0f, (float)prefSize.width() * scale);
        int height = (int)Math.max(1.0f, (float)prefSize.height() * scale);
        return new LytSize(width, height);
    }

    @Nullable
    public LytSize getSizeForPreview() {
        LytSize prefSize = this.viewport.getPreferredSize();
        if (prefSize.width() <= 0 || prefSize.height() <= 0) {
            return null;
        }
        int maxWidth = 400;
        int originalWidth = prefSize.width();
        int originalHeight = prefSize.height();
        double scaleFactor = (double)maxWidth / (double)originalWidth;
        int newHeight = (int)((double)originalHeight * scaleFactor);
        int newWidth = (int)((double)originalWidth * scaleFactor);
        return new LytSize(newWidth, newHeight);
    }

    public void renderToCurrentTarget(LytSize size) {
        if (this.scene == null) {
            return;
        }
        GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
        this.scene.getCameraSettings().setViewportSize(size);
        renderer.render(this.scene.getLevel(), this.scene.getCameraSettings());
    }

    public LytSize getPreferredSize() {
        if (this.scene == null) {
            return LytSize.empty();
        }
        return this.viewport.getPreferredSize();
    }

    public class_1011 asNativeImage(float scale) {
        return null;
    }

    class Viewport {
        Viewport() {
        }

        public LytSize getPreferredSize() {
            if (WrappedScene.this.scene == null) {
                return LytSize.empty();
            }
            SavedCameraSettings current = WrappedScene.this.scene.getCameraSettings().save();
            WrappedScene.this.scene.getCameraSettings().restore(WrappedScene.this.initialCameraSettings);
            Vector4f screenBounds = WrappedScene.this.scene.getScreenBounds();
            WrappedScene.this.scene.getCameraSettings().restore(current);
            int width = (int)Math.ceil(Math.abs(screenBounds.z - screenBounds.x));
            int height = (int)Math.ceil(Math.abs(screenBounds.w - screenBounds.y));
            return new LytSize(width, height);
        }
    }

    public record ImageExport(LytSize size, byte[] image) {
    }
}

