/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.export.level;

import fabric.com.hollingsworth.schematic.common.util.Platform;
import fabric.com.hollingsworth.schematic.export.level.GuidebookChunkSource;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1845;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3568;
import net.minecraft.class_3611;
import net.minecraft.class_3694;
import net.minecraft.class_4076;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5576;
import net.minecraft.class_5577;
import net.minecraft.class_5582;
import net.minecraft.class_5712;
import net.minecraft.class_638;
import net.minecraft.class_6754;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.class_7924;
import net.minecraft.class_8921;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

public class GuidebookLevel
extends class_1937 {
    private static final class_5321<class_1937> LEVEL_ID = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"blockprints", (String)"schematic_world"));
    private final class_5582<class_1297> entityStorage = new class_5582(class_1297.class, (class_5576)new EntityCallbacks());
    private final class_2802 chunkSource = new GuidebookChunkSource(this);
    private final class_6880<class_1959> biome;
    private final class_5455 registryAccess;
    private final LongSet filledBlocks = new LongOpenHashSet();
    private final LongSet litSections = new LongOpenHashSet();
    private final class_2804 defaultDataLayer;

    public GuidebookLevel() {
        this(Platform.getClientRegistryAccess());
    }

    public GuidebookLevel(class_5455 registryAccess) {
        super((class_5269)GuidebookLevel.createLevelData(), LEVEL_ID, registryAccess, (class_6880)registryAccess.method_30530(class_7924.field_41241).method_40290(class_7134.field_37666), () -> class_3694.field_16280, true, false, 0L, 1000000);
        this.registryAccess = registryAccess;
        this.biome = registryAccess.method_30530(class_7924.field_41236).method_40290(class_1972.field_9451);
        byte[] nibbles = new byte[2048];
        Arrays.fill(nibbles, (byte)-1);
        this.defaultDataLayer = new class_2804(nibbles);
    }

    public Bounds getBounds() {
        if (this.filledBlocks.isEmpty()) {
            return new Bounds(class_2338.field_10980, class_2338.field_10980);
        }
        class_2338.class_2339 min = new class_2338.class_2339(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        class_2338.class_2339 max = new class_2338.class_2339(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        class_2338.class_2339 cur = new class_2338.class_2339();
        this.filledBlocks.forEach(packedPos -> {
            cur.method_16363(packedPos);
            min.method_33097(Math.min(min.method_10263(), cur.method_10263()));
            min.method_33098(Math.min(min.method_10264(), cur.method_10264()));
            min.method_33099(Math.min(min.method_10260(), cur.method_10260()));
            max.method_33097(Math.max(max.method_10263(), cur.method_10263() + 1));
            max.method_33098(Math.max(max.method_10264(), cur.method_10264() + 1));
            max.method_33099(Math.max(max.method_10260(), cur.method_10260() + 1));
        });
        return new Bounds((class_2338)min, (class_2338)max);
    }

    public boolean isFilledBlock(class_2338 blockPos) {
        return this.filledBlocks.contains(blockPos.method_10063());
    }

    void removeFilledBlock(class_2338 pos) {
        this.filledBlocks.remove(pos.method_10063());
    }

    void addFilledBlock(class_2338 pos) {
        this.filledBlocks.add(pos.method_10063());
    }

    public void prepareLighting(class_2338 pos) {
        class_1923 minChunk = new class_1923(pos.method_10069(-1, -1, -1));
        class_1923 maxChunk = new class_1923(pos.method_10069(1, 1, 1));
        class_1923.method_19281((class_1923)minChunk, (class_1923)maxChunk).forEach(chunkPos -> {
            if (this.litSections.add(chunkPos.method_8324())) {
                class_3568 lightEngine = this.method_22336();
                for (int i = 0; i < this.method_32890(); ++i) {
                    int y = this.method_31604(i);
                    class_4076 sectionPos = class_4076.method_18681((class_1923)chunkPos, (int)y);
                    lightEngine.method_15551(sectionPos, false);
                    lightEngine.method_15558(class_1944.field_9282, sectionPos, this.defaultDataLayer);
                    lightEngine.method_15558(class_1944.field_9284, sectionPos, this.defaultDataLayer);
                }
                lightEngine.method_15512(chunkPos, true);
                lightEngine.method_51471(chunkPos);
                lightEngine.method_20601(chunkPos, false);
            }
        });
    }

    private static class_638.class_5271 createLevelData() {
        class_638.class_5271 levelData = new class_638.class_5271(class_1267.field_5801, false, false);
        levelData.method_165(6000L);
        return levelData;
    }

    public boolean hasFilledBlocks() {
        return !this.filledBlocks.isEmpty();
    }

    public Stream<class_2338> getFilledBlocks() {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        return this.filledBlocks.longStream().sequential().mapToObj(pos -> {
            mutablePos.method_16363(pos);
            return mutablePos;
        });
    }

    public class_5321<class_1937> method_27983() {
        return field_25179;
    }

    public Set<class_2586> getBlockEntities() {
        return this.getFilledBlocks().map(arg_0 -> ((GuidebookLevel)this).method_8321(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
    }

    protected class_5577<class_1297> method_31592() {
        return this.entityStorage.method_31866();
    }

    @Nullable
    public class_1297 method_8469(int id) {
        return (class_1297)this.method_31592().method_31804(id);
    }

    public class_8921 method_54719() {
        return null;
    }

    public boolean method_31606(class_2338 pPos) {
        return false;
    }

    public boolean method_31601(int pY) {
        return false;
    }

    @Nullable
    public class_2791 method_8402(int pX, int pZ, class_2806 pChunkStatus, boolean pRequireChunk) {
        return super.method_8402(pX, pZ, pChunkStatus, pRequireChunk);
    }

    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
    }

    public void method_8465(@Nullable class_1657 player, double d, double e, double f, class_6880<class_3414> holder, class_3419 soundSource, float g, float h, long l) {
    }

    public void method_8449(@Nullable class_1657 player, class_1297 entity, class_6880<class_3414> holder, class_3419 soundSource, float f, float g, long l) {
    }

    public String method_31419() {
        return "";
    }

    @Nullable
    public class_22 method_17891(class_9209 mapId) {
        return null;
    }

    public class_9209 method_17889() {
        return null;
    }

    public void method_17890(class_9209 mapId, class_22 mapItemSavedData) {
    }

    public void method_8517(int breakerId, class_2338 pos, int progress) {
    }

    public class_269 method_8428() {
        return new class_269();
    }

    public class_1863 method_8433() {
        return Platform.getClientRecipeManager();
    }

    public class_6756<class_2248> method_8397() {
        return class_6754.method_39362();
    }

    public class_6756<class_3611> method_8405() {
        return class_6754.method_39362();
    }

    public class_2802 method_8398() {
        return this.chunkSource;
    }

    public void method_8444(@Nullable class_1657 player, int type, class_2338 pos, int data) {
    }

    public void method_32888(class_6880<class_5712> holder, class_243 vec3, class_5712.class_7397 context) {
    }

    public void method_55764(class_5321<class_5712> pGameEvent, class_2338 pPos, class_5712.class_7397 pContext) {
    }

    public float method_24852(class_2350 direction, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return switch (direction) {
            case class_2350.field_11033 -> 0.5f;
            case class_2350.field_11043, class_2350.field_11035 -> 0.8f;
            case class_2350.field_11039, class_2350.field_11034 -> 0.6f;
            default -> 1.0f;
        };
    }

    public List<? extends class_1657> method_18456() {
        return List.of();
    }

    public class_6880<class_1959> method_22387(int i, int j, int k) {
        return this.biome;
    }

    public class_5455 method_30349() {
        return this.registryAccess;
    }

    public class_1845 method_59547() {
        return null;
    }

    public class_7699 method_45162() {
        return class_7699.method_45397();
    }

    public void setDayTimePerTick(float dayTimePerTick) {
    }

    public void setDayTimeFraction(float dayTimePerTick) {
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    private static class EntityCallbacks
    implements class_5576<class_1297> {
        private EntityCallbacks() {
        }

        public void onCreated(class_1297 entity) {
        }

        public void onDestroyed(class_1297 entity) {
        }

        public void onTickingStart(class_1297 entity) {
        }

        public void onTickingEnd(class_1297 entity) {
        }

        public void onTrackingStart(class_1297 entity) {
        }

        public void onTrackingEnd(class_1297 entity) {
        }

        public void onSectionChange(class_1297 object) {
        }
    }

    public record Bounds(class_2338 min, class_2338 max) {
    }
}

