/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.api.blockprints;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.UUID;
import neoforge.com.hollingsworth.schematic.Constants;
import neoforge.com.hollingsworth.schematic.api.blockprints.ApiError;
import neoforge.com.hollingsworth.schematic.api.blockprints.auth.Auth;
import neoforge.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.Download;
import neoforge.com.hollingsworth.schematic.api.blockprints.favorites.Favorites;
import neoforge.com.hollingsworth.schematic.api.blockprints.upload.Upload;
import neoforge.com.hollingsworth.schematic.oauth.TokenLoader;
import net.minecraft.client.Minecraft;

public class BlockprintsApi {
    private static BlockprintsApi INSTANCE;
    private final Download downloadApi;
    private final Favorites favoritesApi;
    private final Upload uploadApi;
    private final Auth authApi;
    public final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(30L)).build();
    private BlockprintsToken bpToken;
    private static boolean loadedLocalToken;

    public BlockprintsApi() throws ApiError {
        this.downloadApi = new Download(this);
        this.favoritesApi = new Favorites(this);
        this.uploadApi = new Upload(this);
        this.authApi = new Auth(this);
        if (!loadedLocalToken) {
            this.bpToken = TokenLoader.loadToken();
            loadedLocalToken = true;
        }
    }

    public static BlockprintsApi getInstance() throws ApiError {
        UUID playerUuid = Minecraft.getInstance().player.getUUID();
        if (INSTANCE == null) {
            INSTANCE = new BlockprintsApi();
        }
        if (INSTANCE.tokenExpired() || !playerUuid.equals(BlockprintsApi.INSTANCE.bpToken.requesterUUID()) && !Constants.isDev) {
            INSTANCE.setToken(null);
        }
        return INSTANCE;
    }

    public void setToken(BlockprintsToken token) {
        this.bpToken = token;
        if (token != null) {
            TokenLoader.writeToken(token);
        }
    }

    public HttpRequest.Builder getBuilder(boolean includeContentType) {
        HttpRequest.Builder req = HttpRequest.newBuilder();
        if (this.bpToken != null) {
            req = req.header("authorization", this.bpToken.token());
        }
        if (includeContentType) {
            req.header("Content-Type", "application/json");
        }
        return req;
    }

    public HttpRequest.Builder getBuilder() {
        return this.getBuilder(true);
    }

    public boolean tokenExpired() {
        return this.bpToken == null || this.bpToken.tokenExpired();
    }

    public Download download() {
        return this.downloadApi;
    }

    public Favorites favorites() {
        return this.favoritesApi;
    }

    public Upload upload() {
        return this.uploadApi;
    }

    public Auth auth() {
        return this.authApi;
    }

    static {
        loadedLocalToken = false;
    }
}

