/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.api.blockprints.auth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import neoforge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.RequestUtil;
import neoforge.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import neoforge.com.hollingsworth.schematic.oauth.Login;
import net.minecraft.client.Minecraft;

public class Auth {
    private final BlockprintsApi api;
    private final HttpClient CLIENT;

    public Auth(BlockprintsApi api) {
        this.api = api;
        this.CLIENT = this.api.CLIENT;
    }

    public ApiResponse<BlockprintsToken> postMSCode(String code) {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("code", code);
            jsonObject.addProperty("redirectUrl", Login.redirectUri);
            HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/auth/link/msauth")).POST(HttpRequest.BodyPublishers.ofString(jsonObject.toString())).build();
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = res.statusCode();
            if (!RequestUtil.responseSuccessful(statusCode)) {
                throw new Error("Failed to authenticate with Blockprints API");
            }
            JsonObject responseObj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return ApiResponse.success(new BlockprintsToken(responseObj.get("token").getAsString(), responseObj.get("expiresAt").getAsInt(), Minecraft.getInstance().player.getUUID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.unexpectedFailure();
        }
    }
}

