/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.api.blockprints.download;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import neoforge.com.hollingsworth.schematic.Constants;
import neoforge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.GoogleCloudStorage;
import neoforge.com.hollingsworth.schematic.api.blockprints.RequestUtil;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.GetDownloadResponse;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.GetSchematicResponse;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import net.minecraft.network.chat.Component;

public class Download {
    private BlockprintsApi api;
    private final HttpClient CLIENT;

    public Download(BlockprintsApi api) {
        this.api = api;
        this.CLIENT = this.api.CLIENT;
    }

    public GetSchematicResponse getSchematic(String id) {
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/schematics/" + id)).GET().build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                Constants.LOG.error(res.body());
                return null;
            }
            JsonObject responseObj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return new GetSchematicResponse(responseObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GetDownloadResponse getSchematicDownloadUrl(String id) {
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/schematics/" + id + "/download")).GET().build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                Constants.LOG.error(res.body());
                return null;
            }
            JsonObject responseObj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return new GetDownloadResponse(responseObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiResponse<PreviewDownloadResult> downloadPreview(String id) {
        GetSchematicResponse result = this.getSchematic(id);
        if (result == null) {
            return ApiResponse.error((Component)Component.translatable((String)"blockprints.download_not_found"));
        }
        ApiResponse<byte[]> downloaded = GoogleCloudStorage.downloadImage(result.previewImage);
        if (!downloaded.wasSuccessful()) {
            return ApiResponse.error((Component)Component.translatable((String)"blockprints.download_not_found"));
        }
        return ApiResponse.success(new PreviewDownloadResult(result, (byte[])downloaded.response));
    }

    public ApiResponse<Path> downloadSchematic(String schematicId, String name) {
        URI uri;
        GetDownloadResponse result = this.getSchematicDownloadUrl(schematicId);
        if (result == null) {
            return ApiResponse.error((Component)Component.translatable((String)"blockprints.download_not_found"));
        }
        String link = result.url;
        try {
            uri = new URI(link);
        }
        catch (Exception e) {
            return ApiResponse.error((Component)Component.translatable((String)"blockprints.download_not_found"));
        }
        return ApiResponse.success(GoogleCloudStorage.downloadFromUrl(uri, "./schematics/", name + "_" + schematicId, ".nbt"));
    }
}

