/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import neoforge.com.hollingsworth.schematic.ClientConstants;
import neoforge.com.hollingsworth.schematic.client.ClientData;
import neoforge.com.hollingsworth.schematic.client.RaycastHelper;
import neoforge.com.hollingsworth.schematic.client.VecHelper;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.PlaceSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.UploadPreviewScreen;
import neoforge.com.hollingsworth.schematic.common.util.SchematicExport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AreaCaptureHandler {
    public static BlockPos firstTarget;
    public static BlockPos secondTarget;
    public static boolean showBoundary;
    public static PlaceSchematicScreen schematicTools;
    public static Direction selectedFace;
    public static BlockPos selectedPos;

    public static void startCapture() {
        showBoundary = true;
        firstTarget = null;
        secondTarget = null;
        schematicTools = new PlaceSchematicScreen();
    }

    public static void cancelCapture() {
        showBoundary = false;
        firstTarget = null;
        secondTarget = null;
    }

    public static void onConfirmHit() {
        if (!showBoundary) {
            return;
        }
        showBoundary = false;
        if (firstTarget != null && secondTarget != null) {
            StructureTemplate structure = SchematicExport.getStructure((Level)Minecraft.getInstance().level, firstTarget, secondTarget);
            Minecraft.getInstance().setScreen((Screen)new UploadPreviewScreen(structure, firstTarget, secondTarget));
        }
    }

    public static void onCancelHit() {
        if (!showBoundary) {
            return;
        }
        AreaCaptureHandler.cancelCapture();
    }

    public static void renderBoundary(PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (!showBoundary) {
            return;
        }
        BlockPos firstPos = firstTarget;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.level(), (Player)player, 75.0);
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockPos hit = trace.getBlockPos();
            boolean replaceable = player.level().getBlockState(hit).canBeReplaced(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
            if (trace.getDirection().getAxis().isVertical() && !replaceable) {
                hit = hit.relative(trace.getDirection());
            }
            selectedPos = hit;
        } else {
            selectedPos = null;
        }
        if (firstPos == null && selectedPos != null) {
            AreaCaptureHandler.renderBbox(new AABB(selectedPos), poseStack, modelViewMatrix);
            return;
        }
        BlockPos secondPos = secondTarget;
        if (secondPos == null) {
            secondPos = selectedPos;
        }
        AABB currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (selectedPos == null ? null : new AABB(selectedPos)) : (selectedPos == null ? new AABB(firstPos) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)selectedPos).expandTowards(1.0, 1.0, 1.0))) : AABB.encapsulatingFullBlocks((BlockPos)firstPos, (BlockPos)secondPos).expandTowards(1.0, 1.0, 1.0);
        AreaCaptureHandler.renderBbox(currentSelectionBox, poseStack, modelViewMatrix);
    }

    public static void renderBbox(AABB currentSelectionBox, PoseStack poseStack, Matrix4f modelViewMatrix) {
        if (currentSelectionBox == null) {
            return;
        }
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        currentSelectionBox.move(camera.scale(-1.0));
        currentSelectionBox = currentSelectionBox.move(-camera.x, -camera.y, -camera.z);
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        VertexConsumer vertexconsumer = ClientConstants.bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (AABB)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        ClientConstants.bufferSource.endBatch();
        poseStack.popPose();
    }

    public static boolean positionClicked() {
        if (!showBoundary) {
            return false;
        }
        BlockPos pos = selectedPos;
        if (pos == null) {
            return false;
        }
        if (firstTarget == null) {
            firstTarget = pos.immutable();
            return true;
        }
        if (secondTarget == null && !firstTarget.equals((Object)pos)) {
            secondTarget = pos.immutable();
            return true;
        }
        return false;
    }

    public static boolean mouseScrolled(double delta) {
        if (!showBoundary || firstTarget == null || secondTarget == null) {
            return false;
        }
        if (!Screen.hasControlDown()) {
            return false;
        }
        if (selectedFace == null) {
            return true;
        }
        AABB bb = new AABB((double)firstTarget.getX(), (double)firstTarget.getY(), (double)firstTarget.getZ(), (double)secondTarget.getX(), (double)secondTarget.getY(), (double)secondTarget.getZ());
        Vec3i vec = selectedFace.getNormal();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        if (bb.contains(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.getX() * delta);
        int y = (int)((double)vec.getY() * delta);
        int z = (int)((double)vec.getZ() * delta);
        Direction.AxisDirection axisDirection = selectedFace.getAxisDirection();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.move((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.maxX - (double)(x * axisDirection.getStep()), bb.minX);
        double maxY = Math.max(bb.maxY - (double)(y * axisDirection.getStep()), bb.minY);
        double maxZ = Math.max(bb.maxZ - (double)(z * axisDirection.getStep()), bb.minZ);
        bb = new AABB(bb.minX, bb.minY, bb.minZ, maxX, maxY, maxZ);
        firstTarget = BlockPos.containing((double)bb.minX, (double)bb.minY, (double)bb.minZ);
        secondTarget = BlockPos.containing((double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        LocalPlayer player = Minecraft.getInstance().player;
        player.displayClientMessage((Component)Component.translatable((String)"blockprints.dimensions", (Object[])new Object[]{(int)bb.getXsize() + 1, (int)bb.getYsize() + 1, (int)bb.getZsize() + 1}), true);
        return true;
    }

    public static void tick() {
        selectedFace = null;
        if (secondTarget != null) {
            Vec3 projectedView;
            LocalPlayer player = Minecraft.getInstance().player;
            AABB bb = AABB.encapsulatingFullBlocks((BlockPos)firstTarget, (BlockPos)secondTarget).expandTowards(1.0, 1.0, 1.0).inflate((double)0.45f);
            boolean inside = bb.contains(projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((Player)player, 70.0, pos -> inside ^ bb.contains(VecHelper.getCenterOf((Vec3i)pos)));
            selectedFace = result.missed() ? null : (inside ? result.getFacing().getOpposite() : result.getFacing());
        }
    }

    public static void renderBoundaryUI(GuiGraphics graphics, Window window) {
        if (!showBoundary || Minecraft.getInstance().options.hideGui) {
            return;
        }
        float screenY = (float)window.getGuiScaledHeight() / 2.0f;
        float screenX = (float)window.getGuiScaledWidth() / 2.0f;
        float instructionY = window.getGuiScaledHeight() - 42;
        graphics.pose().pushPose();
        graphics.pose().translate(screenX, instructionY, 0.0f);
        if (firstTarget != null && secondTarget != null) {
            GuiUtils.drawCenteredOutlinedText(Minecraft.getInstance().font, graphics, (Component)Component.translatable((String)"blockprints.expand_box"), 0, -16);
            GuiUtils.drawCenteredOutlinedText(Minecraft.getInstance().font, graphics, Component.translatable((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.getTranslatedKeyMessage()}).getVisualOrderText(), 0, 0);
        } else {
            String compKey = firstTarget == null ? "select_first" : "select_second";
            GuiUtils.drawCenteredOutlinedText(Minecraft.getInstance().font, graphics, Component.translatable((String)("blockprints." + compKey)).getVisualOrderText(), 0, 0);
        }
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate(screenX, instructionY + 10.0f, 0.0f);
        GuiUtils.drawCenteredOutlinedText(Minecraft.getInstance().font, graphics, Component.translatable((String)"blockprints.cancel_selection", (Object[])new Object[]{ClientData.CANCEL.getTranslatedKeyMessage()}).getVisualOrderText(), 0, 0);
        graphics.pose().popPose();
    }

    static {
        schematicTools = new PlaceSchematicScreen();
        selectedFace = null;
        selectedPos = null;
    }
}

