/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import neoforge.com.hollingsworth.schematic.client.AreaCaptureHandler;
import neoforge.com.hollingsworth.schematic.client.KeyEvent;
import neoforge.com.hollingsworth.schematic.client.RenderStructureHandler;
import neoforge.com.hollingsworth.schematic.client.gui.HomeScreen;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.joml.Matrix4f;

public class ClientData {
    private static final String CATEGORY = "key.category.blockprints.general";
    public static final KeyMapping OPEN_MENU = new KeyMapping("key.blockprints.open_menu", 96, "key.category.blockprints.general");
    public static final KeyMapping CONFIRM = new KeyMapping("key.blockprints.confirm_selection", 257, "key.category.blockprints.general");
    public static final KeyMapping CANCEL = new KeyMapping("key.blockprints.cancel_selection", 259, "key.category.blockprints.general");
    public static final KeyMapping TOOL_MENU = new KeyMapping("key.blockprints.tool_menu", 342, "key.category.blockprints.general");
    public static final KeyFunction[] KEY_FUNCTIONS = new KeyFunction[]{new KeyFunction(OPEN_MENU, ClientData::openMenu), new KeyFunction(CONFIRM, ClientData::onConfirmHit), new KeyFunction(CANCEL, ClientData::onCancelHit), new KeyFunction(TOOL_MENU, RenderStructureHandler::toolKeyHit)};

    public static void openMenu(KeyEvent event) {
        if (event.isDown()) {
            Minecraft.getInstance().setScreen((Screen)new HomeScreen());
        }
    }

    public static void startBoundaryCapture() {
        AreaCaptureHandler.startCapture();
        RenderStructureHandler.cancelRender();
    }

    public static void startStructureRenderer(StructureTemplate structureTemplate, String name, String blockprintsId) {
        RenderStructureHandler.startRender(structureTemplate, name, blockprintsId);
        AreaCaptureHandler.cancelCapture();
    }

    public static void onConfirmHit(KeyEvent event) {
        if (!event.isDown()) {
            return;
        }
        AreaCaptureHandler.onConfirmHit();
    }

    public static void onCancelHit(KeyEvent event) {
        if (!event.isDown()) {
            return;
        }
        AreaCaptureHandler.onCancelHit();
    }

    public static void renderAfterSky(PoseStack poseStack, Matrix4f modelViewMatrix) {
        AreaCaptureHandler.renderBoundary(poseStack, modelViewMatrix);
    }

    public static void renderAfterTransparentBlocks(PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix) {
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.buildRender(data, poseStack, (Player)Minecraft.getInstance().player);
        }
        for (StructureRenderData data : StructureRenderer.structures) {
            StructureRenderer.drawRender(data, poseStack, projectionMatrix, modelViewMatrix, (Player)Minecraft.getInstance().player);
        }
    }

    public static boolean mouseScrolled(double delta) {
        return RenderStructureHandler.mouseScrolled(delta) || AreaCaptureHandler.mouseScrolled(delta);
    }

    public static void rightClickEvent() {
        AreaCaptureHandler.positionClicked();
        RenderStructureHandler.positionClicked();
    }

    public static void renderGUIOverlayEvent(GuiGraphics graphics, Window window) {
        AreaCaptureHandler.renderBoundaryUI(graphics, window);
        RenderStructureHandler.renderInstructions(graphics, window);
    }

    public static void tickEvent() {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().level == null) {
            return;
        }
        RenderStructureHandler.tick();
        AreaCaptureHandler.tick();
    }

    public record KeyFunction(KeyMapping mapping, Consumer<KeyEvent> function) {
    }
}

