/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client;

import neoforge.com.hollingsworth.schematic.client.ClientData;
import neoforge.com.hollingsworth.schematic.client.KeyEvent;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(value={Dist.CLIENT}, modid="blockprints")
public class ClientEvents {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    @SubscribeEvent
    public static void keyEvent(InputEvent.Key event) {
        if (Minecraft.getInstance().player == null || ClientEvents.MINECRAFT.screen != null) {
            return;
        }
        for (ClientData.KeyFunction keyMapping : ClientData.KEY_FUNCTIONS) {
            if (keyMapping.mapping().isUnbound() || keyMapping.mapping().getKey().getValue() != event.getKey()) continue;
            keyMapping.function().accept(new KeyEvent(keyMapping.mapping(), event.getAction()));
        }
    }

    @SubscribeEvent
    public static void rightClickEvent(InputEvent.MouseButton.Pre event) {
        if (1 != event.getButton() || ClientEvents.MINECRAFT.screen != null || event.getAction() != 0) {
            return;
        }
        ClientData.rightClickEvent();
    }

    @SubscribeEvent
    public static void scrollEvent(InputEvent.MouseScrollingEvent event) {
        boolean cancel = ClientData.mouseScrolled(event.getScrollDeltaY());
        event.setCanceled(cancel);
    }

    @SubscribeEvent
    public static void renderLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            ClientData.renderAfterTransparentBlocks(event.getPoseStack(), event.getProjectionMatrix(), event.getModelViewMatrix());
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        ClientData.renderAfterSky(event.getPoseStack(), event.getModelViewMatrix());
    }

    @SubscribeEvent
    public static void afterRenderOverlayLayer(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            return;
        }
        ClientData.renderGUIOverlayEvent(event.getGuiGraphics(), Minecraft.getInstance().getWindow());
    }

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Post event) {
        ClientData.tickEvent();
    }
}

