/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import neoforge.com.hollingsworth.schematic.client.KeyEvent;
import neoforge.com.hollingsworth.schematic.client.RaycastHelper;
import neoforge.com.hollingsworth.schematic.client.gui.PlaceSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import neoforge.com.hollingsworth.schematic.networking.PlaceSchematicPacket;
import neoforge.com.hollingsworth.schematic.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RenderStructureHandler {
    private static StructureRenderData placingData;
    private static PlaceSchematicScreen schematicTools;

    public static void tick() {
        if (placingData == null) {
            return;
        }
        schematicTools.update();
    }

    public static void startRender(StructureTemplate structureTemplate, String name, String bpId) {
        if (placingData != null) {
            RenderStructureHandler.cancelRender();
        }
        placingData = new StructureRenderData(structureTemplate, name, bpId);
        schematicTools = new PlaceSchematicScreen();
        StructureRenderer.structures.add(placingData);
    }

    public static void cancelRender() {
        if (placingData == null) {
            return;
        }
        StructureRenderer.structures.remove(placingData);
        placingData = null;
    }

    public static void onConfirmHit() {
        if (placingData == null) {
            return;
        }
        placingData = null;
    }

    public static void setAnchor() {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.placingData.anchorPos = RaycastHelper.getLookingAt(RenderStructureHandler.placingData.distanceFromCameraCast, (Player)Minecraft.getInstance().player, true).getBlockPos();
        schematicTools.setupManipulationTools();
    }

    public static void onZoom(boolean zoomIn) {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.placingData.distanceFromCameraCast = zoomIn ? (RenderStructureHandler.placingData.distanceFromCameraCast += 1.0) : (RenderStructureHandler.placingData.distanceFromCameraCast -= 1.0);
    }

    public static void positionClicked() {
        if (placingData == null) {
            return;
        }
        schematicTools.getSelectedElement().onClick();
    }

    public static void onRotateHit(boolean clockwise) {
        if (placingData == null) {
            return;
        }
        placingData.rotate(clockwise ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        RenderStructureHandler.placingData.lastRenderPos = null;
    }

    public static void offsetAnchor(BlockPos pos) {
        if (placingData == null || RenderStructureHandler.placingData.anchorPos == null) {
            return;
        }
        RenderStructureHandler.placingData.anchorPos = RenderStructureHandler.placingData.anchorPos.offset((Vec3i)pos);
    }

    public static void onFlip() {
        if (placingData == null) {
            return;
        }
        placingData.flip();
        RenderStructureHandler.placingData.lastRenderPos = null;
    }

    public static void toolKeyHit(KeyEvent event) {
        if (placingData == null) {
            return;
        }
        boolean pressed = event.isDown();
        if (pressed && !RenderStructureHandler.schematicTools.focused) {
            RenderStructureHandler.schematicTools.focused = true;
        }
        if (!pressed && RenderStructureHandler.schematicTools.focused) {
            RenderStructureHandler.schematicTools.focused = false;
            schematicTools.onClose();
        }
    }

    public static boolean mouseScrolled(double delta) {
        if (placingData == null) {
            return false;
        }
        return schematicTools.scroll(delta);
    }

    public static void renderInstructions(GuiGraphics graphics, Window window) {
        if (placingData == null) {
            return;
        }
        schematicTools.renderPassive(graphics, 0.0f);
    }

    public static void placeOnServer() {
        if (placingData == null) {
            return;
        }
        Services.PLATFORM.sendClientToServerPacket(new PlaceSchematicPacket(RenderStructureHandler.placingData.structureTemplate, RenderStructureHandler.placingData.structurePlaceSettings, RenderStructureHandler.placingData.anchorPos.above(1)));
    }

    static {
        schematicTools = new PlaceSchematicScreen();
    }
}

