/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderType TRANSLUCENT = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);

    public static void drawItemAsIcon(ItemStack stack, PoseStack poseStack, float x, float y, float scale) {
        if (stack.isEmpty()) {
            return;
        }
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getModel(stack, null, (LivingEntity)Minecraft.getInstance().player, 0);
        RenderUtils.renderItemModel(poseStack, stack, x, y, scale, 0, model, renderer, 150);
    }

    public static void renderItemModel(PoseStack poseStack, ItemStack stack, float x, float y, float scale, int alpha, BakedModel model, ItemRenderer renderer, int zIndex) {
        boolean flatLight;
        poseStack.pushPose();
        poseStack.translate(x + 8.0f, y + 8.0f, (float)zIndex);
        poseStack.mulPose(SCALE_INVERT_Y);
        poseStack.scale(scale, scale, scale);
        boolean bl = flatLight = !model.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        renderer.render(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        poseStack.popPose();
    }
}

