/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.ArrayList;
import java.util.List;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.BlockEntryRow;
import neoforge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.VerticalSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlockListScreen
extends BaseSchematicScreen {
    public Screen previousScreen;
    List<DownloadScreen.BlockListEntry> entries;
    List<BlockEntryRow> rows = new ArrayList<BlockEntryRow>();
    int scroll = 0;
    VerticalSlider slider;

    public BlockListScreen(Screen previousScreen, List<DownloadScreen.BlockListEntry> entries) {
        this.previousScreen = previousScreen;
        this.entries = entries;
        this.entries.sort((o1, o2) -> {
            if (o1.isMissing && !o2.isMissing) {
                return -1;
            }
            if (!o1.isMissing && o2.isMissing) {
                return 1;
            }
            return Integer.compare(o2.count, o1.count);
        });
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen(this.previousScreen)));
        this.updateList();
        int maxScroll = Math.max(0, this.entries.size() - 10);
        this.slider = this.addRenderableWidget(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, maxScroll, 1.0, 1, this::scrollChange));
    }

    public void scrollChange(int change) {
        this.scroll = change;
        this.updateList();
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.slider.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY)) {
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void updateList() {
        for (BlockEntryRow row : this.rows) {
            this.removeWidget((GuiEventListener)row);
        }
        this.rows = new ArrayList<BlockEntryRow>();
        List<DownloadScreen.BlockListEntry> sliced = this.entries.subList(this.scroll, Math.min(this.scroll + 10, this.entries.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            DownloadScreen.BlockListEntry entry = sliced.get(i);
            BlockEntryRow row = new BlockEntryRow(this.bookLeft + 25, this.bookTop + 43 + i * 14, entry);
            this.rows.add(row);
            this.addRenderableWidget(row);
        }
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/container_list_blocks.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        graphics.drawString(this.font, (Component)Component.translatable((String)"blockprints.block"), 30, 29, 0, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"blockprints.qty"), 235, 29, 0, false);
    }
}

