/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import neoforge.com.hollingsworth.schematic.api.SceneExporter;
import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import neoforge.com.hollingsworth.schematic.client.ClientData;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.BlockListScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import neoforge.com.hollingsworth.schematic.client.gui.PreviewImage;
import neoforge.com.hollingsworth.schematic.common.util.ClientUtil;
import neoforge.com.hollingsworth.schematic.common.util.FileUtils;
import neoforge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.lwjgl.system.MemoryUtil;

public class DownloadScreen
extends BaseSchematicScreen {
    public static final ResourceLocation PREVIEW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"download_preview");
    DynamicTexture dynamicTexture;
    PreviewDownloadResult preview;
    Screen previousScreen;
    List<BlockListEntry> entries = new ArrayList<BlockListEntry>();
    boolean hasMissing = false;

    public DownloadScreen(Screen previousScreen, PreviewDownloadResult preview) {
        this.previousScreen = previousScreen;
        this.preview = preview;
        for (Tuple<ResourceLocation, Integer> entry : preview.downloadResponse.blockCounts) {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)((ResourceLocation)entry.getA()).toString());
            int count = (Integer)entry.getB();
            boolean exists = BuiltInRegistries.BLOCK.containsKey(resourceLocation);
            Block thing = (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
            if (!exists) {
                this.entries.add(new BlockListEntry(resourceLocation.toString(), count));
                this.hasMissing = true;
                continue;
            }
            ItemStack renderStack = new ItemStack((ItemLike)thing);
            this.entries.add(new BlockListEntry(renderStack.getHoverName().getString(), (Integer)entry.getB(), renderStack));
        }
    }

    public static LoadingScreen<PreviewDownloadResult> getTransition(String schematicId, Screen previousScreen) {
        return new LoadingScreen<PreviewDownloadResult>(() -> BlockprintsApi.getInstance().download().downloadPreview(schematicId), result -> Minecraft.getInstance().setScreen((Screen)new DownloadScreen(previousScreen, (PreviewDownloadResult)result)), previousScreen);
    }

    public static DynamicTexture getTexture(byte[] img) throws IOException {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)img.length);
        buffer.put(img);
        NativeImage nativeImage = NativeImage.read((ByteBuffer)buffer.flip());
        return new DynamicTexture(nativeImage);
    }

    @Override
    public void init() {
        super.init();
        try {
            this.dynamicTexture = DownloadScreen.getTexture(this.preview.image);
            Minecraft.getInstance().getTextureManager().register(PREVIEW_TEXTURE, (AbstractTexture)this.dynamicTexture);
            this.addRenderableWidget(new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, PREVIEW_TEXTURE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuiImageButton downloadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 153, 95, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_6.png"), b -> this.startDownload(path -> {
            Minecraft.getInstance().setScreen(null);
            if (path != null) {
                ClientUtil.sendMessage("blockprints.download_success");
            } else {
                ClientUtil.sendMessage("blockprints.download_failed");
            }
        }));
        String fileName = SceneExporter.sanitize(this.preview.downloadResponse.structureName + "_" + this.preview.downloadResponse.id) + ".nbt";
        Path path = Paths.get("./schematics/", fileName);
        boolean alreadyDownloaded = Files.exists(path, new LinkOption[0]);
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 25, this.bookTop + 153, 143, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_9.png"), b -> Minecraft.getInstance().setScreen((Screen)new BlockListScreen(this, this.entries))));
        GuiImageButton visualizeButton = new GuiImageButton(this.bookLeft + 25, this.bookTop + 153 + 16, 143, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_9.png"), b -> {
            Consumer<Path> onPath = templatePath -> {
                StructureTemplate structureTemplate = FileUtils.loadStructureTemplate((HolderGetter<Block>)Minecraft.getInstance().level.holderLookup(Registries.BLOCK), templatePath);
                StructureTemplateAccessor accessor = (StructureTemplateAccessor)structureTemplate;
                List<StructureTemplate.Palette> palettes = accessor.getPalettes();
                if (palettes.isEmpty()) {
                    Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"blockprints.invalid_file"));
                } else {
                    ClientData.startStructureRenderer(structureTemplate, this.preview.downloadResponse.structureName, this.preview.downloadResponse.id);
                }
                Minecraft.getInstance().setScreen(null);
            };
            if (!alreadyDownloaded) {
                this.startDownload(onPath);
            } else {
                onPath.accept(path);
            }
        });
        if (alreadyDownloaded) {
            downloadButton.withTooltip((Component)Component.translatable((String)"blockprints.already_downloaded_tooltip", (Object[])new Object[]{"./schematics/" + fileName}).withStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        } else {
            downloadButton.withTooltip((Component)(this.hasMissing ? Component.translatable((String)"blockprints.blocks_missing_tooltip").withStyle(Style.EMPTY.withColor(ChatFormatting.RED)) : null)).withTooltip((Component)Component.translatable((String)"blockprints.download_tooltip"));
            visualizeButton.withTooltip((Component)Component.translatable((String)"blockprints.visualize_download"));
        }
        this.addRenderableWidget(visualizeButton);
        this.addRenderableWidget(downloadButton);
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen(this.previousScreen)));
    }

    public void startDownload(Consumer<Path> callback) {
        Minecraft.getInstance().setScreen(new LoadingScreen<Path>(() -> BlockprintsApi.getInstance().download().downloadSchematic(this.preview.downloadResponse.id, this.preview.downloadResponse.structureName), callback));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_download.png"), this.bookRight - 116, this.bookTop + 155, 0.0f, 0.0f, 9, 11, 9, 11);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_list.png"), this.bookLeft + 28, this.bookTop + 157, 0.0f, 0.0f, 9, 7, 9, 7);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_visualize.png"), this.bookLeft + 28, this.bookTop + 157 + 16, 0.0f, 0.0f, 9, 7, 9, 7);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.download").getVisualOrderText(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.view_list").getVisualOrderText(), this.bookLeft + 34 + 71, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.visualize").getVisualOrderText(), this.bookLeft + 34 + 71, this.bookTop + 157 + 16);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_title_body.png"), 185, 25, 0.0f, 0.0f, 95, 127, 95, 127);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, (Component)Component.literal((String)this.preview.downloadResponse.structureName), 96, 29);
        graphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)this.preview.downloadResponse.description), 187, 44, 95, 0);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, (Component)Component.translatable((String)"blockprints.description_title"), 232, 29);
    }

    public void removed() {
        super.removed();
        Minecraft.getInstance().getTextureManager().release(PREVIEW_TEXTURE);
    }

    public static class BlockListEntry {
        public String name;
        public int count;
        public ItemStack renderStack;
        public boolean isMissing;

        public BlockListEntry(String name, int count, ItemStack renderStack) {
            this.name = name;
            this.count = count;
            this.renderStack = renderStack;
            this.isMissing = false;
        }

        public BlockListEntry(String name, int count) {
            this(name, count, ItemStack.EMPTY);
            this.isMissing = true;
        }
    }
}

