/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.List;
import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.CheckBoxButton;
import neoforge.com.hollingsworth.schematic.client.gui.ConfirmDeleteScreen;
import neoforge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import neoforge.com.hollingsworth.schematic.client.gui.NoScrollMultiText;
import neoforge.com.hollingsworth.schematic.client.gui.PreviewImage;
import neoforge.com.hollingsworth.schematic.client.gui.ShortTextField;
import neoforge.com.hollingsworth.schematic.client.gui.ViewFavoritesScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EditBuildScreen
extends BaseSchematicScreen {
    DynamicTexture dynamicTexture;
    PreviewDownloadResult preview;
    ViewFavoritesScreen previousScreen;
    ShortTextField nameField;
    NoScrollMultiText descriptionField;
    GuiImageButton uploadButton;
    GuiImageButton deleteButton;
    public boolean makePublic = false;

    public EditBuildScreen(ViewFavoritesScreen previousScreen, PreviewDownloadResult preview) {
        this.previousScreen = previousScreen;
        this.preview = preview;
        this.makePublic = preview.downloadResponse.isPublic;
    }

    public static LoadingScreen<PreviewDownloadResult> getTransition(String code, ViewFavoritesScreen previousScreen) {
        return new LoadingScreen<PreviewDownloadResult>(() -> BlockprintsApi.getInstance().download().downloadPreview(code), build -> Minecraft.getInstance().setScreen((Screen)new EditBuildScreen(previousScreen, (PreviewDownloadResult)build)), previousScreen);
    }

    @Override
    public void init() {
        super.init();
        try {
            this.dynamicTexture = DownloadScreen.getTexture(this.preview.image);
            Minecraft.getInstance().getTextureManager().register(DownloadScreen.PREVIEW_TEXTURE, (AbstractTexture)this.dynamicTexture);
            this.addRenderableWidget(new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, DownloadScreen.PREVIEW_TEXTURE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nameField = new ShortTextField(this.font, this.bookLeft + 185, this.bookTop + 39, (Component)Component.empty());
        this.descriptionField = new NoScrollMultiText(this.font, this.bookLeft + 185, this.bookTop + 71, 95, 81, (Component)Component.empty(), (Component)Component.empty());
        this.nameField.setValue(this.preview.downloadResponse.structureName);
        this.descriptionField.setValue(this.preview.downloadResponse.description);
        this.uploadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 169, 79, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_5.png"), b -> {
            String name = this.nameField.getValue().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100 || name.length() < 10 || desc.length() > 1000 || desc.length() < 20) {
                return;
            }
            Minecraft.getInstance().setScreen(new LoadingScreen<Boolean>(() -> BlockprintsApi.getInstance().upload().postEdit(this.preview.downloadResponse.id, name, desc, this.makePublic), build -> Minecraft.getInstance().setScreen(ViewFavoritesScreen.getTransition(this.previousScreen)), this));
        });
        this.deleteButton = new GuiImageButton(this.bookRight - 39, this.bookTop + 169, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_delete.png"), b -> Minecraft.getInstance().setScreen((Screen)new ConfirmDeleteScreen(this.preview, ViewFavoritesScreen.getTransition(this.previousScreen), this))).withTooltip((Component)Component.translatable((String)"blockprints.delete_tooltip"));
        this.addRenderableWidget(this.uploadButton);
        this.addRenderableWidget(this.deleteButton);
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen((Screen)this.previousScreen)));
        this.addRenderableWidget(this.nameField);
        this.addRenderableWidget(this.descriptionField);
        this.addRenderableWidget(new CheckBoxButton(this.bookRight - 119, this.bookTop + 153, b -> {
            this.makePublic = !this.makePublic;
        }, () -> this.makePublic).withTooltip((Component)Component.translatable((String)"blockprints.make_public_tooltip")));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_upload.png"), this.bookRight - 116, this.bookTop + 171, 0.0f, 0.0f, 9, 11, 9, 11);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.make_public").getVisualOrderText(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.save").getVisualOrderText(), this.bookRight - 70, this.bookTop + 173);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_title.png"), 185, 25, 0.0f, 0.0f, 95, 14, 95, 14);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_title.png"), 185, 57, 0.0f, 0.0f, 95, 14, 95, 14);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.preview").getVisualOrderText(), 96, 29);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.name").getVisualOrderText(), 233, 29);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.description").getVisualOrderText(), 233, 61);
    }

    public void removed() {
        super.removed();
        Minecraft.getInstance().getTextureManager().release(DownloadScreen.PREVIEW_TEXTURE);
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.uploadButton)) {
            String name = this.nameField.getValue().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100) {
                tooltip.add((Component)Component.translatable((String)"blockprints.name_too_long"));
            }
            if (name.length() < 10) {
                tooltip.add((Component)Component.translatable((String)"blockprints.name_too_short"));
            }
            if (desc.length() > 1000) {
                tooltip.add((Component)Component.translatable((String)"blockprints.description_too_long"));
            }
            if (desc.length() < 20) {
                tooltip.add((Component)Component.translatable((String)"blockprints.description_too_short"));
            }
        }
    }
}

