/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.favorites.Favorite;
import neoforge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import neoforge.com.hollingsworth.schematic.client.gui.EditBuildScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import neoforge.com.hollingsworth.schematic.client.gui.NestedWidget;
import neoforge.com.hollingsworth.schematic.client.gui.ViewFavoritesScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FavoritesRow
extends NestedWidget {
    Favorite favorite;
    ViewFavoritesScreen viewBuildsScreen;

    public FavoritesRow(int x, int y, Favorite favorite, ViewFavoritesScreen screen) {
        super(x, y, 236, 12, (Component)Component.empty());
        this.favorite = favorite;
        this.viewBuildsScreen = screen;
        if (favorite.isBuild()) {
            this.renderables.add(new GuiImageButton(x + 224, y + 1, 11, 11, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_edit.png"), button -> Minecraft.getInstance().setScreen(EditBuildScreen.getTransition(favorite.id(), this.viewBuildsScreen))).withTooltip((Component)Component.translatable((String)"blockprints.edit")));
        } else if (favorite.isFavorite()) {
            this.renderables.add(new GuiImageButton(x + 224, y + 1, 11, 11, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_remove_favorite.png"), button -> Minecraft.getInstance().setScreen(new LoadingScreen<Boolean>(() -> BlockprintsApi.getInstance().favorites().removeFavorite(favorite.id()), res -> Minecraft.getInstance().setScreen(ViewFavoritesScreen.getTransition(this.viewBuildsScreen.showFavorites, this.viewBuildsScreen.showBuilds, this.viewBuildsScreen.showRecent))))).withTooltip((Component)Component.translatable((String)"blockprints.remove_favorite")));
        } else {
            this.renderables.add(new GuiImageButton(x + 224, y + 1, 11, 11, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_add_favorite.png"), button -> Minecraft.getInstance().setScreen(new LoadingScreen<Boolean>(() -> BlockprintsApi.getInstance().favorites().addFavorite(favorite.id()), res -> Minecraft.getInstance().setScreen(ViewFavoritesScreen.getTransition(this.viewBuildsScreen.showFavorites, this.viewBuildsScreen.showBuilds, this.viewBuildsScreen.showRecent))))).withTooltip((Component)Component.translatable((String)"blockprints.add_favorite")));
        }
        this.renderables.add(new GuiImageButton(x + 211, y + 1, 11, 11, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_copy.png"), button -> Minecraft.getInstance().keyboardHandler.setClipboard(favorite.id())).withTooltip((Component)Component.translatable((String)"blockprints.copy")));
        this.renderables.add(new GuiImageButton(x + 198, y + 1, 11, 11, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_view.png"), button -> Minecraft.getInstance().setScreen(DownloadScreen.getTransition(favorite.id(), this.viewBuildsScreen))).withTooltip((Component)Component.translatable((String)"blockprints.view")));
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int i, int i1, float v) {
        graphics.drawString(Minecraft.getInstance().font, this.favorite.name(), this.x + 16, this.y + 3, 0, false);
        if (this.viewBuildsScreen.showBuilds && this.favorite.isBuild()) {
            graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_my_builds.png"), this.x + 4, this.y + 3, 0.0f, 0.0f, 5, 7, 5, 7);
        } else if (this.viewBuildsScreen.showFavorites && this.favorite.isFavorite()) {
            graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_favorite_builds.png"), this.x + 4, this.y + 3, 0.0f, 0.0f, 7, 7, 7, 7);
        } else if (this.viewBuildsScreen.showRecent && this.favorite.isRecent()) {
            graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_recent_builds.png"), this.x + 4, this.y + 3, 0.0f, 0.0f, 7, 7, 7, 7);
        }
    }
}

