/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import neoforge.com.hollingsworth.schematic.client.gui.button.ANButton;
import neoforge.com.hollingsworth.schematic.common.util.ITooltipProvider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiImageButton
extends ANButton
implements ITooltipProvider {
    public ResourceLocation image;
    public int u;
    public int v;
    public int image_width;
    public int image_height;
    public List<Component> toolTip = new ArrayList<Component>();
    public boolean soundDisabled = false;

    public GuiImageButton(int x, int y, int w, int h, ResourceLocation image, Button.OnPress onPress) {
        this(x, y, 0, 0, w, h, w, h, image, onPress);
    }

    public GuiImageButton(int x, int y, int u, int v, int w, int h, int image_width, int image_height, String resource_image, Button.OnPress onPress) {
        this(x, y, u, v, w, h, image_width, image_height, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)resource_image), onPress);
    }

    public GuiImageButton(int x, int y, int u, int v, int w, int h, int image_width, int image_height, ResourceLocation image, Button.OnPress onPress) {
        super(x, y, w, h, (Component)Component.literal((String)""), onPress);
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.image_height = image_height;
        this.image_width = image_width;
        this.image = image;
    }

    public GuiImageButton withTooltip(@Nullable Component toolTip) {
        if (toolTip == null) {
            return this;
        }
        this.toolTip.add(toolTip);
        return this;
    }

    public GuiImageButton withTooltip(@NotNull List<Component> tooltip) {
        this.toolTip = tooltip;
        return this;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            pGuiGraphics.blit(this.image, this.x, this.y, (float)this.u, (float)this.v, this.width, this.height, this.image_width, this.image_height);
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.toolTip != null) {
            tooltip.addAll(this.toolTip);
        }
    }

    public void playDownSound(SoundManager pHandler) {
        if (this.soundDisabled) {
            return;
        }
        super.playDownSound(pHandler);
    }

    public void setPosition(int pX, int pY) {
        this.x = pX;
        this.y = pY;
    }
}

