/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.Objects;
import neoforge.com.hollingsworth.schematic.ClientConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;

public class GuiUtils {
    public static boolean isMouseInRelativeRange(double mouseX, double mouseY, AbstractWidget widget) {
        return GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }

    public static boolean isMouseInRelativeRange(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
    }

    public static boolean isMouseInRelativeRange(int mouseX, int mouseY, AbstractWidget widget) {
        return GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
    }

    public static boolean isMouseInRelativeRange(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    public static void drawCenteredStringNoShadow(Font font, GuiGraphics graphics, Component component, int x, int y, int color) {
        graphics.drawString(font, component.getString(), x - GuiUtils.halfWidthOfText(font, component.getVisualOrderText()), y, color, false);
    }

    public static void drawOutlinedText(Font font, GuiGraphics graphics, Component component, int x, int y) {
        GuiUtils.drawOutlinedText(font, graphics, component.getVisualOrderText(), x, y);
    }

    public static void drawOutlinedText(Font font, GuiGraphics graphics, FormattedCharSequence component, int x, int y) {
        font.drawInBatch8xOutline(component, (float)x, (float)y, DyeColor.WHITE.getTextColor(), DyeColor.BLACK.getTextColor(), graphics.pose().last().pose(), (MultiBufferSource)ClientConstants.bufferSource, 0xF000F0);
        ClientConstants.bufferSource.endBatch();
    }

    public static void drawCenteredOutlinedText(Font font, GuiGraphics graphics, FormattedCharSequence component, int x, int y) {
        GuiUtils.drawOutlinedText(font, graphics, component, x - GuiUtils.halfWidthOfText(font, component), y);
    }

    public static void drawCenteredOutlinedText(Font font, GuiGraphics graphics, Component component, int x, int y) {
        GuiUtils.drawCenteredOutlinedText(font, graphics, component.getVisualOrderText(), x, y);
    }

    public static void drawOutlinedWordWrap(GuiGraphics graphics, Font font, Component component, int x, int y, int wrapLength) {
        for (FormattedCharSequence $$6 : font.split((FormattedText)component, wrapLength)) {
            GuiUtils.drawOutlinedText(font, graphics, $$6, x, y);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static int halfWidthOfText(Font font, FormattedCharSequence component) {
        return font.width(component) / 2;
    }
}

