/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.function.Consumer;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSlider;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HorizontalSlider
extends BaseSlider {
    public boolean isPitch;
    Consumer<Integer> onChange;

    public HorizontalSlider(int x, int y, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean isPitch, Consumer<Integer> onChange) {
        super(x, y, 95, 15, prefix, suffix, minValue, maxValue, currentValue, stepSize, precision, true);
        this.onChange = onChange;
        this.isPitch = isPitch;
    }

    @Override
    protected void applyValue() {
        super.applyValue();
        this.onChange.accept(this.getValueInt());
    }

    @Override
    public void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY != 0.0) {
            this.setValue(this.getValue() + (double)(pScrollY > 0.0 ? -1 : 1) * this.stepSize);
            this.applyValue();
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        String image = this.isPitch ? "textures/gui/container_scroll_pitch.png" : "textures/gui/container_scroll_yaw.png";
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)image), this.x - 16, this.y, 0.0f, 0.0f, 143, 15, 143, 15);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/scroll_bar_horizontal.png"), this.x + 1 + (int)(this.value * (double)(this.width - 9)), this.getY() + 3, 0.0f, 0.0f, 15, 9, 15, 9);
        GuiUtils.drawCenteredOutlinedText(mc.font, guiGraphics, Component.literal((String)String.valueOf(this.getValueInt())).getVisualOrderText(), this.x + 116, this.y + 4);
    }
}

