/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import neoforge.com.hollingsworth.schematic.Constants;
import neoforge.com.hollingsworth.schematic.api.blockprints.ApiError;
import neoforge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.HomeScreen;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class LoadingScreen<T>
extends BaseSchematicScreen {
    int ticksRunning;
    boolean backAdded = false;
    boolean addHomeButton = false;
    int anim;
    Supplier<ApiResponse<T>> future;
    Consumer<T> onSuccess;
    String error = null;
    public boolean responseHandled = false;
    Response<T> response;
    public Screen previousScreen = null;
    CompletableFuture<ApiResponse<T>> completableFuture;

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess, Screen previousScreen) {
        this(future, onSuccess);
        this.previousScreen = previousScreen;
    }

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess, Screen previousScreen, int ticksRunning) {
        this(future, onSuccess, previousScreen);
        this.ticksRunning = ticksRunning;
    }

    public LoadingScreen(Supplier<ApiResponse<T>> future, Consumer<T> onSuccess) {
        this.future = future;
        this.onSuccess = onSuccess;
        this.completableFuture = CompletableFuture.supplyAsync(future, Util.backgroundExecutor()).whenCompleteAsync((result, err) -> {
            this.response = new Response(result, (Throwable)err);
        }, (Executor)Minecraft.getInstance());
    }

    @Override
    public void init() {
        super.init();
    }

    public void handleResponse() {
        if (this.response == null) {
            return;
        }
        this.responseHandled = true;
        ApiResponse<T> apiResponse = this.response.response();
        if (this.response.throwable != null) {
            CompletionException completionException;
            Throwable throwable = this.response.throwable;
            if (throwable instanceof CompletionException && (throwable = (completionException = (CompletionException)throwable).getCause()) instanceof ApiError) {
                ApiError apiError = (ApiError)throwable;
                apiResponse = apiError.toApiResponse();
            } else {
                this.response.throwable.printStackTrace();
                this.error = Component.translatable((String)"blockprints.unexpected_error", (Object[])new Object[]{this.response.throwable.getMessage()}).getString();
                this.addHomeButton();
                return;
            }
        }
        if (apiResponse == null || apiResponse.response == null && apiResponse.error == null) {
            Constants.LOG.error("Empty response with no error.");
            this.error = Component.translatable((String)"blockprints.unexpected_error").getString();
            this.addHomeButton();
            return;
        }
        if (apiResponse.error != null) {
            this.error = apiResponse.error;
            Constants.LOG.error("Error: " + apiResponse.error);
            this.addHomeButton();
        } else {
            this.onSuccess.accept(apiResponse.response);
        }
    }

    public void tick() {
        super.tick();
        ++this.ticksRunning;
        ++this.anim;
        if (this.anim > 50) {
            this.anim = 0;
        }
        if (this.response != null && !this.responseHandled) {
            this.handleResponse();
        }
        if (!(this.ticksRunning != 100 && this.error == null || this.backAdded)) {
            this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen((Screen)(this.previousScreen != null ? this.previousScreen : new HomeScreen()))));
            this.backAdded = true;
        }
    }

    public void onClose() {
        super.onClose();
        if (this.completableFuture != null && !this.completableFuture.isDone() && !this.completableFuture.isCancelled()) {
            this.completableFuture.cancel(true);
        }
    }

    public boolean shouldCloseOnEsc() {
        return this.canCancel();
    }

    public boolean canCancel() {
        return this.ticksRunning > 100 || this.error != null;
    }

    public void addHomeButton() {
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 105, this.bookTop + 137, 95, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_6.png"), b -> Minecraft.getInstance().setScreen((Screen)new HomeScreen())));
        this.addHomeButton = true;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.addHomeButton) {
            graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_home.png"), this.bookLeft + 108, this.bookTop + 140, 0.0f, 0.0f, 9, 8, 9, 8);
            GuiUtils.drawOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.home").getVisualOrderText(), this.bookLeft + 128, this.bookTop + 141);
        }
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/container_loading_status.png"), 0, 0, 0.0f, 0.0f, 305, 209, 305, 209);
        if (this.error != null) {
            graphics.drawWordWrap(this.font, (FormattedText)Component.literal((String)this.error), 92, 77, 125, 0xFFFFFF);
            return;
        }
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/animation_logo_loading.png"), 144, 91, 0.0f, (float)(26 * (this.anim / 2)), 14, 26, 14, 650);
        String dots = "";
        dots = this.anim < 13 ? "" : (this.anim < 26 ? "." : (this.anim < 39 ? ".." : "..."));
        MutableComponent component = Component.translatable((String)"blockprints.loading");
        MutableComponent compWithDots = Component.literal((String)(component.getString() + dots));
        int loadingX = 152;
        int centered = loadingX - this.font.width((FormattedText)component) / 2;
        graphics.drawString(this.font, (Component)compWithDots, centered, 120, 0xFFFFFF, false);
    }

    protected record Response<T>(ApiResponse<T> response, @Nullable Throwable throwable) {
    }
}

