/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.io.IOException;
import neoforge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import neoforge.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.HomeScreen;
import neoforge.com.hollingsworth.schematic.oauth.Login;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class LoginScreen
extends BaseSchematicScreen {
    Runnable onLogin;
    Component message;

    public LoginScreen(Runnable onLogin) {
        this.onLogin = onLogin;
        this.message = Component.translatable((String)"blockprints.login_desc");
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen((Screen)new HomeScreen())));
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 105, this.bookTop + 137, 95, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_6.png"), b -> this.initLogin()));
    }

    @Override
    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_website.png"), this.bookLeft + 107, this.bookTop + 139, 0.0f, 0.0f, 11, 11, 11, 11);
        GuiUtils.drawOutlinedText(this.font, matrixStack, Component.translatable((String)"blockprints.start_login").getVisualOrderText(), this.bookLeft + 128, this.bookTop + 141);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/container_loading_status.png"), 0, 0, 0.0f, 0.0f, 305, 209, 305, 209);
        graphics.drawWordWrap(this.font, (FormattedText)this.message, 92, 77, 125, 0xFFFFFF);
    }

    private void initLogin() {
        this.message = Component.translatable((String)"blockprints.complete_login");
        try {
            Login.startOAuthFlow(token -> {
                BlockprintsApi.getInstance().setToken((BlockprintsToken)token);
                this.onLogin.run();
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"blockprints.login_success"));
            });
        }
        catch (IOException e) {
            this.message = Component.literal((String)("Encountered error: " + e.getMessage()));
        }
    }

    public void onClose() {
        super.onClose();
        Login.abortAuth();
    }
}

