/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.ArrayList;
import java.util.List;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.HomeScreen;
import neoforge.com.hollingsworth.schematic.client.gui.VerticalSlider;
import neoforge.com.hollingsworth.schematic.client.gui.VisualEntryRow;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ManageVisualScreen
extends BaseSchematicScreen {
    List<VisualEntryRow> rows = new ArrayList<VisualEntryRow>();
    ArrayList<StructureRenderData> structures = StructureRenderer.structures;
    int scroll = 0;
    VerticalSlider slider;

    @Override
    public void init() {
        super.init();
        this.updateList();
        int maxScroll = Math.max(0, this.structures.size() - 10);
        this.slider = this.addRenderableWidget(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, maxScroll, 1.0, 1, this::scrollChange));
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen((Screen)new HomeScreen())));
    }

    public void scrollChange(int change) {
        this.scroll = change;
        this.updateList();
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.slider.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY)) {
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void updateList() {
        for (VisualEntryRow row : this.rows) {
            this.removeWidget((GuiEventListener)row);
        }
        this.rows = new ArrayList<VisualEntryRow>();
        List<StructureRenderData> sliced = this.structures.subList(this.scroll, Math.min(this.scroll + 10, this.structures.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            StructureRenderData entry = sliced.get(i);
            VisualEntryRow row = new VisualEntryRow(this.bookLeft + 26, this.bookTop + 44 + i * 14, entry, this);
            this.rows.add(row);
            this.addRenderableWidget(row);
        }
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/container_list_visualizer.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        GuiUtils.drawOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.visualizations").getVisualOrderText(), 30, 29);
    }
}

