/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.common.util.ITooltipProvider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public abstract class ModScreen
extends Screen {
    public int maxScale;
    public float scaleFactor;
    public int FULL_WIDTH;
    public int FULL_HEIGHT;
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public int bookBottom;

    public ModScreen(int width, int height) {
        super((Component)Component.empty());
        this.FULL_HEIGHT = height;
        this.FULL_WIDTH = width;
    }

    public void init() {
        super.init();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        this.bookLeft = this.width / 2 - this.FULL_WIDTH / 2;
        this.bookTop = this.height / 2 - this.FULL_HEIGHT / 2;
        this.bookRight = this.width / 2 + this.FULL_WIDTH / 2;
        this.bookBottom = this.height / 2 + this.FULL_HEIGHT / 2;
    }

    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = matrixStack.pose();
        poseStack.pushPose();
        if (this.scaleFactor != 1.0f) {
            poseStack.scale(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(matrixStack, mouseX, mouseY, partialTicks);
        poseStack.popPose();
    }

    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!(renderable instanceof ITooltipProvider)) continue;
            ITooltipProvider tooltipProvider = (ITooltipProvider)renderable;
            if (!GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget)) continue;
            tooltipProvider.getTooltip(tooltip);
            break;
        }
    }

    @Nullable
    public Renderable getHoveredRenderable(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable)) continue;
            return renderable;
        }
        return null;
    }

    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(this.getBgTexture(), 0, 0, 0.0f, 0.0f, this.FULL_WIDTH, this.FULL_HEIGHT, this.FULL_WIDTH, this.FULL_HEIGHT);
    }

    public void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.minecraft.getWindow().calculateScale(0, this.minecraft.isEnforceUnicode());
    }

    public abstract ResourceLocation getBgTexture();

    public static void blitRect(PoseStack matrixStack, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, ResourceLocation texture, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float tx0 = xt / (float)tWidth;
        float ty0 = yt / (float)tHeight;
        float tx1 = tx0 + width / (float)tWidth;
        float ty1 = ty0 + height / (float)tHeight;
        float x1 = x0 + width;
        float y1 = y0 + height;
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder builder = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = matrixStack.last().pose();
        builder.addVertex(matrix, x0, y1, 0.0f).setUv(tx0, ty1);
        builder.addVertex(matrix, x1, y1, 0.0f).setUv(tx1, ty1);
        builder.addVertex(matrix, x1, y0, 0.0f).setUv(tx1, ty0);
        builder.addVertex(matrix, x0, y0, 0.0f).setUv(tx0, ty0);
        MeshData meshdata = builder.build();
        if (meshdata != null) {
            BufferUploader.drawWithShader((MeshData)meshdata);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

