/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import neoforge.com.hollingsworth.schematic.ClientConstants;
import neoforge.com.hollingsworth.schematic.SchematicMod;
import neoforge.com.hollingsworth.schematic.client.ClientData;
import neoforge.com.hollingsworth.schematic.client.RenderStructureHandler;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PlaceSchematicScreen
extends Screen {
    public static PlaceTool placeTool = new PlaceTool();
    public static RotateTool rotateTool = new RotateTool();
    public static MoveHorizontalTool moveHorizontalTool = new MoveHorizontalTool();
    public static MoveVerticalTool moveVerticalTool = new MoveVerticalTool();
    public static ConfirmTool confirmTool = new ConfirmTool();
    public static PrintTool printTool = new PrintTool();
    public static DeleteTool deleteTool = new DeleteTool();
    public static MirrorTool mirrorTool = new MirrorTool();
    public final String holdToFocus = "blockprints.gui.toolmenu.focusKey";
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;
    public List<ToolType> tools = new ArrayList<ToolType>();

    public PlaceSchematicScreen() {
        super((Component)Component.literal((String)"Tool Selection"));
        this.minecraft = Minecraft.getInstance();
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        this.h = 34;
        this.tools.add(new PlaceTool());
    }

    public void setupManipulationTools() {
        this.tools.clear();
        this.tools.add(moveHorizontalTool);
        this.tools.add(moveVerticalTool);
        this.tools.add(rotateTool);
        this.tools.add(confirmTool);
        if (Minecraft.getInstance().player.isCreative() && ClientConstants.blockprintsServerside) {
            this.tools.add(printTool);
        }
        this.tools.add(deleteTool);
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains(tool)) {
            return;
        }
        this.selection = this.tools.indexOf(tool);
    }

    public ToolType getSelectedElement() {
        return this.tools.get(this.selection);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(GuiGraphics graphics, float partialTicks) {
        this.w = Math.max(this.tools.size() * 50 + 32, 220);
        PoseStack matrixStack = graphics.pose();
        Window mainWindow = this.minecraft.getWindow();
        if (!this.initialized) {
            this.init(this.minecraft, mainWindow.getGuiScaledWidth(), mainWindow.getGuiScaledHeight());
        }
        int x = (mainWindow.getGuiScaledWidth() - this.w) / 2 + 14;
        int y = mainWindow.getGuiScaledHeight() - this.h - 34;
        matrixStack.pushPose();
        matrixStack.translate(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        graphics.blit(SchematicMod.prefix("textures/gui/hud_background.png"), x - 15, y, 0.0f, 0.0f, this.w, this.h, 16, 16);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        if (toolTipAlpha > 0.25f) {
            graphics.blit(SchematicMod.prefix("textures/gui/hud_background.png"), x - 15, y + 16, 0.0f, 0.0f, this.w, this.h, 16, 16);
            if (!toolTip.isEmpty()) {
                GuiUtils.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(0), x - 10, y + 38);
            }
            if (toolTip.size() > 1) {
                GuiUtils.drawOutlinedText(this.minecraft.font, graphics, toolTip.get(1), x - 10, y + 50);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = ClientData.TOOL_MENU.getTranslatedKeyMessage().getString();
            int width = this.minecraft.getWindow().getGuiScaledWidth();
            if (!this.focused) {
                GuiUtils.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"blockprints.gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10);
            } else {
                GuiUtils.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"blockprints.scroll"), width / 2, y - 10);
            }
        } else {
            GuiUtils.drawCenteredOutlinedText(this.minecraft.font, graphics, (Component)Component.translatable((String)"blockprints.place_description"), this.width / 2, y - 10);
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            matrixStack.pushPose();
            if (i == this.selection) {
                matrixStack.translate(0.0f, -10.0f, 0.0f);
                GuiUtils.drawCenteredOutlinedText(this.minecraft.font, graphics, this.tools.get(i).getDisplayName(), x + i * 50 + 26, y + 28);
            }
            ResourceLocation icon = this.tools.get(i).getIcon();
            graphics.blit(icon, x + i * 50 + 16, y + 11, 0.0f, 0.0f, 16, 16, 16, 16);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public boolean scroll(double delta) {
        if (this.focused) {
            this.cycle((int)delta);
            return true;
        }
        if (PlaceSchematicScreen.hasControlDown()) {
            return this.tools.get(this.selection).handleMouseWheel(delta);
        }
        return false;
    }

    public void renderPassive(GuiGraphics graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void onClose() {
    }

    protected void init() {
        super.init();
        this.initialized = true;
    }

    public static class PlaceTool
    extends ToolType {
        public PlaceTool() {
            super((Component)Component.translatable((String)"blockprints.place_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_place.png"));
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.place_description"));
            return list;
        }

        @Override
        public void onClick() {
            RenderStructureHandler.setAnchor();
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onZoom(delta > 0.0);
            return true;
        }
    }

    public static class MoveHorizontalTool
    extends ToolType {
        public MoveHorizontalTool() {
            super((Component)Component.translatable((String)"blockprints.move_horizontal_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_horizontal.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            Direction direction = Minecraft.getInstance().player.getNearestViewDirection();
            BlockPos offset = new BlockPos((int)delta * direction.getStepX(), 0, (int)delta * direction.getStepZ());
            RenderStructureHandler.offsetAnchor(offset);
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.move_horizontal_description"));
            return list;
        }
    }

    public static class MoveVerticalTool
    extends ToolType {
        public MoveVerticalTool() {
            super((Component)Component.translatable((String)"blockprints.move_vertical_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_vertical.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.offsetAnchor(new BlockPos(0, (int)delta, 0));
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.move_vertical_description"));
            return list;
        }
    }

    public static class RotateTool
    extends ToolType {
        public RotateTool() {
            super((Component)Component.translatable((String)"blockprints.rotate_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_rotate.png"));
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.rotate_description"));
            return list;
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onRotateHit(delta > 0.0);
            return true;
        }
    }

    public static class ConfirmTool
    extends ToolType {
        public ConfirmTool() {
            super((Component)Component.translatable((String)"blockprints.confirm_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_confirm.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.onConfirmHit();
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.confirm_description"));
            return list;
        }
    }

    public static class PrintTool
    extends ToolType {
        public PrintTool() {
            super((Component)Component.translatable((String)"blockprints.print_tool"), SchematicMod.prefix("textures/gui/visualizer_print.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.placeOnServer();
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.print_description"));
            return list;
        }
    }

    public static class DeleteTool
    extends ToolType {
        public DeleteTool() {
            super((Component)Component.translatable((String)"blockprints.delete_tool"), SchematicMod.prefix("textures/gui/visualizer_trash.png"));
        }

        @Override
        public void onClick() {
            RenderStructureHandler.cancelRender();
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.delete_description"));
            return list;
        }
    }

    public static abstract class ToolType {
        Component name;
        ResourceLocation icon;

        public ToolType(Component name, ResourceLocation icon) {
            this.name = name;
            this.icon = icon;
        }

        public void onClick() {
        }

        public Component getDisplayName() {
            return this.name;
        }

        abstract List<Component> getDescription();

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public boolean handleMouseWheel(double delta) {
            return false;
        }
    }

    public static class MirrorTool
    extends ToolType {
        public MirrorTool() {
            super((Component)Component.translatable((String)"blockprints.mirror_tool"), SchematicMod.prefix("textures/gui/visualizer_icon_mirror.png"));
        }

        @Override
        public boolean handleMouseWheel(double delta) {
            RenderStructureHandler.onFlip();
            return true;
        }

        @Override
        List<Component> getDescription() {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"blockprints.mirror_description"));
            return list;
        }
    }
}

