/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import neoforge.com.hollingsworth.schematic.client.gui.ModScreen;
import neoforge.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import neoforge.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import neoforge.com.hollingsworth.schematic.client.renderer.StatePos;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import neoforge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import neoforge.com.hollingsworth.schematic.export.CameraSettings;
import neoforge.com.hollingsworth.schematic.export.LytSize;
import neoforge.com.hollingsworth.schematic.export.OffScreenRenderer;
import neoforge.com.hollingsworth.schematic.export.Scene;
import neoforge.com.hollingsworth.schematic.export.WrappedScene;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ScenePreview
extends AbstractWidget {
    private int yaw = 225;
    private int pitch = 30;
    private int roll;
    public WrappedScene wrappedScene;
    public Scene scene;
    public OffScreenRenderer renderer;
    StructureTemplate template;
    FakeRenderingWorld fakeRenderingWorld;
    StructureRenderData cachedRender;
    boolean doSort;
    int sortDebounce;

    public ScenePreview(int x, int y, int width, int height, Scene scene, WrappedScene wrappedScene, StructureTemplate template) {
        super(x, y, width, height, (Component)Component.empty());
        this.wrappedScene = wrappedScene;
        this.scene = scene;
        this.cachedRender = new StructureRenderData(template, null, null);
        StructureRenderer.generateRender(this.cachedRender, (Level)Minecraft.getInstance().level, BlockPos.ZERO, 1.0f, new Vec3(0.0, 0.0, 0.0));
        this.scheduleSort();
    }

    public void updateSceneTexture() {
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        if (prefSize.width() > 0 && prefSize.height() > 0) {
            int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
            int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
            if (this.renderer == null || this.renderer.width != renderWidth || this.renderer.height != renderHeight) {
                if (this.renderer != null) {
                    this.renderer.close();
                }
                this.renderer = new OffScreenRenderer(renderWidth, renderHeight);
            }
            this.renderer.renderToTexture(this::renderTarget);
        }
    }

    public void renderTarget() {
        this.wrappedScene.renderToCurrentTarget(this.wrappedScene.getPreferredSize());
    }

    public void removed() {
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
    }

    public void tick() {
        if (this.doSort) {
            if (this.sortDebounce > 0) {
                --this.sortDebounce;
            } else {
                this.doSort = false;
                ScenePreview.sortAll(this.cachedRender, new Vec3(0.0, 0.0, 0.0));
            }
        }
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int previewX = this.x;
        int previewY = this.y;
        float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        boolean doOldRender = false;
        if (doOldRender) {
            this.updateSceneTexture();
            if (this.renderer != null) {
                int imageWidth = this.renderer.width;
                int imageHeight = this.renderer.height;
                LytSize origDim = new LytSize(imageWidth, imageHeight);
                LytSize boundary = new LytSize(this.width, this.height);
                LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
                int x = previewX + 71;
                int y = previewY + 55;
                this.innerBlit(graphics.pose(), this.renderer, x -= newDim.width() / 2, x + newDim.width(), y -= newDim.height() / 2, y + newDim.height(), 0);
            }
            return;
        }
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize size = this.wrappedScene.getPreferredSize();
        this.scene.getCameraSettings().setViewportSize(size);
        CameraSettings cameraSettings = this.scene.getCameraSettings();
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
        int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
        LytSize origDim = new LytSize(renderWidth, renderHeight);
        LytSize boundary = new LytSize(this.width, this.height);
        LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
        int x = previewX + 71;
        int y = previewY + 71;
        RenderSystem.viewport((int)((int)((float)(x -= newDim.width() / 2) * scale)), (int)((int)((float)(y -= newDim.height() / 2) * scale)), (int)((int)((float)newDim.width() * scale)), (int)((int)((float)newDim.height() * scale)));
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.setIdentity();
        poseStack.mulPose(viewMatrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        RenderSystem.runAsFancy(() -> this.drawRenderScreen(poseStack, (Player)Minecraft.getInstance().player, this.cachedRender.statePosCache));
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)Minecraft.getInstance().getWindow().getWidth(), (int)Minecraft.getInstance().getWindow().getHeight());
        RenderSystem.restoreProjectionMatrix();
        ModScreen.blitRect(graphics.pose(), x + 121, y + 3, 0.0f, 0.0f, 17.0f, 17.0f, 17, 17, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/gimbal/gimbal_cardinal.png"), 150);
    }

    void innerBlit(PoseStack pose, OffScreenRenderer osr, int x1, int x2, int y1, int y2, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (int)osr.fb.getColorTextureId());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
    }

    public static LytSize getScaledDimension(LytSize imgSize, LytSize boundary) {
        int original_width = imgSize.width();
        int original_height = imgSize.height();
        int bound_width = boundary.width();
        int bound_height = boundary.height();
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new LytSize(new_width, new_height);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager $$0) {
    }

    public void drawRenderScreen(PoseStack matrix, Player player, ArrayList<StatePos> statePosCache) {
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.solid());
        drawSet.add(RenderType.cutout());
        drawSet.add(RenderType.cutoutMipped());
        drawSet.add(RenderType.translucent());
        drawSet.add(RenderType.tripwire());
        try {
            Iterator iterator = drawSet.iterator();
            while (iterator.hasNext()) {
                RenderType renderType;
                RenderType drawRenderType = renderType = (RenderType)iterator.next();
                VertexBuffer vertexBuffer = this.cachedRender.vertexBuffers.get(renderType);
                if (vertexBuffer.getFormat() == null) continue;
                drawRenderType.setupRenderState();
                vertexBuffer.bind();
                vertexBuffer.drawWithShader(matrix.last().pose(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                VertexBuffer.unbind();
                drawRenderType.clearRenderState();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.pushPose();
        matrix.setIdentity();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 1.0f);
        if (this.fakeRenderingWorld == null) {
            this.fakeRenderingWorld = new FakeRenderingWorld((Level)Minecraft.getInstance().level, statePosCache, BlockPos.ZERO);
        }
        for (StatePos pos : statePosCache) {
            if (pos.state.isAir() || StructureRenderer.isModelRender(pos.state)) continue;
            matrix.pushPose();
            matrix.translate((float)pos.pos.getX(), (float)pos.pos.getY(), (float)pos.pos.getZ());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            BlockEntity blockEntity = this.fakeRenderingWorld.getBlockEntity(pos.pos);
            if (blockEntity != null) {
                BlockEntityRenderer renderer = blockEntityRenderer.getRenderer(blockEntity);
                try {
                    renderer.render(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, 0xF00000, OverlayTexture.NO_OVERLAY);
                }
                catch (Exception exception) {}
            } else {
                try {
                    DireRenderMethods.renderBETransparent(this.fakeRenderingWorld.getBlockState(pos.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 1.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            matrix.popPose();
        }
        matrix.popPose();
        buffersource.endLastBatch();
    }

    public static void sortAll(StructureRenderData data, Vec3 projectedView) {
        for (Map.Entry<RenderType, MeshData.SortState> entry : data.sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            ByteBufferBuilder.Result renderedBuffer = ScenePreview.sort(data, projectedView, renderType);
            VertexBuffer vertexBuffer = data.vertexBuffers.get(renderType);
            vertexBuffer.bind();
            vertexBuffer.uploadIndexBuffer(renderedBuffer);
            VertexBuffer.unbind();
        }
    }

    public static ByteBufferBuilder.Result sort(StructureRenderData data, Vec3 projectedView, RenderType renderType) {
        Vec3 inverted = projectedView.scale(-1.0);
        Vec3 subtracted = projectedView.add(inverted.normalize().scale(0.1));
        Vector3f sortPos = new Vector3f((float)(-subtracted.x), (float)(-subtracted.y), (float)(-subtracted.z));
        return data.sortStates.get(renderType).buildSortedIndexBuffer(data.getByteBuffer(renderType), VertexSorting.byDistance(v -> -sortPos.distanceSquared((Vector3fc)v)));
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
        this.scheduleSort();
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = pitch;
        this.scheduleSort();
    }

    public int getRoll() {
        return this.roll;
    }

    public void setRoll(int roll) {
        this.roll = roll;
        this.scheduleSort();
    }

    private void scheduleSort() {
        this.doSort = true;
        this.sortDebounce = 20;
    }
}

