/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.List;
import neoforge.com.hollingsworth.schematic.api.SceneExporter;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import neoforge.com.hollingsworth.schematic.client.gui.CheckBoxButton;
import neoforge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import neoforge.com.hollingsworth.schematic.client.gui.GimbalButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import neoforge.com.hollingsworth.schematic.client.gui.GuiUtils;
import neoforge.com.hollingsworth.schematic.client.gui.HomeScreen;
import neoforge.com.hollingsworth.schematic.client.gui.HorizontalSlider;
import neoforge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import neoforge.com.hollingsworth.schematic.client.gui.NoScrollMultiText;
import neoforge.com.hollingsworth.schematic.client.gui.PreviewImage;
import neoforge.com.hollingsworth.schematic.client.gui.ScenePreview;
import neoforge.com.hollingsworth.schematic.client.gui.ShortTextField;
import neoforge.com.hollingsworth.schematic.common.util.ClientUtil;
import neoforge.com.hollingsworth.schematic.export.CameraSettings;
import neoforge.com.hollingsworth.schematic.export.Scene;
import neoforge.com.hollingsworth.schematic.export.WrappedScene;
import neoforge.com.hollingsworth.schematic.export.level.GuidebookLevel;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class UploadPreviewScreen
extends BaseSchematicScreen {
    ScenePreview scenePreview;
    HorizontalSlider yawSlider;
    HorizontalSlider pitchSlider;
    ShortTextField nameField;
    NoScrollMultiText descriptionField;
    GuiImageButton uploadButton;
    public StructureTemplate structureTemplate;
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MIN_NAME_LENGTH = 10;
    public static final int MAX_DESC_LENGTH = 1000;
    public static final int MIN_DESC_LENGTH = 20;
    public boolean makePublic = false;
    public BlockPos start;
    public BlockPos end;
    DynamicTexture dynamicTexture;
    WrappedScene wrappedScene;
    int pitch;
    int yaw;
    boolean useRealtimeRender = true;
    PreviewImage previewImage;

    public UploadPreviewScreen(StructureTemplate structureTemplate, BlockPos start, BlockPos end) {
        this.structureTemplate = structureTemplate;
        this.start = start;
        this.end = end;
    }

    @Override
    public void init() {
        super.init();
        this.wrappedScene = new WrappedScene();
        Scene scene = new Scene(new GuidebookLevel(), new CameraSettings());
        this.wrappedScene.setScene(scene);
        this.wrappedScene.placeStructure(this.structureTemplate);
        this.nameField = new ShortTextField(this.font, this.bookLeft + 185, this.bookTop + 39, (Component)Component.empty());
        this.descriptionField = new NoScrollMultiText(this.font, this.bookLeft + 185, this.bookTop + 71, 95, 81, (Component)Component.empty(), (Component)Component.empty());
        this.uploadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 169, 95, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_6.png"), b -> {
            String name = this.nameField.getValue().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100 || name.length() < 10 || desc.length() > 1000 || desc.length() < 20) {
                return;
            }
            SceneExporter sceneExporter = new SceneExporter(this.wrappedScene, this.structureTemplate);
            if (sceneExporter.scene.getSizeForExport(2.0f) == null) {
                Minecraft.getInstance().setScreen(null);
                ClientUtil.sendMessage((Component)Component.translatable((String)"blockprints.invalid_upload").withStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                return;
            }
            List<WrappedScene.ImageExport> images = sceneExporter.getImages();
            Minecraft.getInstance().setScreen(new LoadingScreen<String>(() -> sceneExporter.writeAndUpload(images, this.nameField.getValue(), this.descriptionField.getValue(), this.makePublic, this.start, this.end), res -> {
                Minecraft.getInstance().setScreen(null);
                String url = "https://blockprints.io/schematic/" + res;
                ClientUtil.sendMessage((Component)Component.translatable((String)"blockprints.upload_complete", (Object[])new Object[]{Component.literal((String)url).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))}));
            }));
        });
        this.addRenderableWidget(this.uploadButton);
        this.addRenderableWidget(this.nameField);
        this.addRenderableWidget(this.descriptionField);
        this.yawSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 153, (Component)Component.empty(), (Component)Component.empty(), 0.0, 360.0, 225.0, 5.0, 1, false, this::setYaw);
        this.pitchSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 169, (Component)Component.empty(), (Component)Component.empty(), 0.0, 90.0, 30.0, 5.0, 1, true, this::setPitch);
        this.addRenderableWidget(this.yawSlider);
        this.addRenderableWidget(this.pitchSlider);
        this.updateExport();
        this.previewImage = new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, DownloadScreen.PREVIEW_TEXTURE);
        this.useRealtimeRender = true;
        if (this.useRealtimeRender) {
            this.scenePreview = new ScenePreview(this.bookLeft + 25, this.bookTop + 41, 100, 100, scene, this.wrappedScene, this.structureTemplate);
            this.scenePreview.setYaw(225);
            this.scenePreview.setPitch(30);
            this.addRenderableWidget(this.scenePreview);
        } else {
            this.addRenderableWidget(this.previewImage);
        }
        this.addRenderableWidget(new GimbalButton(this.bookLeft + 155, this.bookTop + 47, "northeast", b -> {
            this.setYaw(225);
            this.setPitch(30);
        }));
        this.addRenderableWidget(new GimbalButton(this.bookLeft + 149, this.bookTop + 47, "northwest", b -> {
            this.setYaw(135);
            this.setPitch(30);
        }));
        this.addRenderableWidget(new GimbalButton(this.bookLeft + 149, this.bookTop + 53, "southwest", b -> {
            this.setYaw(45);
            this.setPitch(30);
        }));
        this.addRenderableWidget(new GimbalButton(this.bookLeft + 155, this.bookTop + 53, "southeast", b -> {
            this.setYaw(315);
            this.setPitch(30);
        }));
        this.addRenderableWidget(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/button_back.png"), b -> Minecraft.getInstance().setScreen((Screen)new HomeScreen())));
        this.addRenderableWidget(new CheckBoxButton(this.bookRight - 119, this.bookTop + 153, b -> {
            this.makePublic = !this.makePublic;
        }, () -> this.makePublic).withTooltip((Component)Component.translatable((String)"blockprints.make_public_tooltip")));
    }

    public void tick() {
        super.tick();
        this.scenePreview.tick();
    }

    public void removed() {
        super.removed();
        this.scenePreview.removed();
        if (this.dynamicTexture != null) {
            this.dynamicTexture.close();
        }
    }

    public void setYaw(int yaw) {
        this.scenePreview.setYaw(yaw);
        this.yaw = yaw;
        this.yawSlider.setValue(yaw);
        this.updateExport();
    }

    public void setPitch(int pitch) {
        this.scenePreview.setPitch(pitch);
        this.pitch = pitch;
        this.pitchSlider.setValue(pitch);
        this.updateExport();
    }

    public void updateExport() {
        if (this.useRealtimeRender) {
            return;
        }
        try {
            Scene scene = this.wrappedScene.scene;
            scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, 0.0f);
            scene.getCameraSettings().setRotationCenter(scene.getWorldCenter());
            scene.getCameraSettings().setZoom(1.0f);
            scene.centerScene();
            WrappedScene.ImageExport res = this.wrappedScene.exportPreviewPng();
            if (res == null) {
                System.out.println("Failed to export preview");
                return;
            }
            this.dynamicTexture = DownloadScreen.getTexture(res.image());
            Minecraft.getInstance().getTextureManager().register(DownloadScreen.PREVIEW_TEXTURE, (AbstractTexture)this.dynamicTexture);
            this.previewImage.dynamicTexture = this.dynamicTexture;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/icon_upload.png"), this.bookRight - 116, this.bookTop + 171, 0.0f, 0.0f, 9, 11, 9, 11);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.make_public").getVisualOrderText(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.upload").getVisualOrderText(), this.bookRight - 67, this.bookTop + 173);
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.uploadButton)) {
            String name = this.nameField.getValue().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100) {
                tooltip.add((Component)Component.translatable((String)"blockprints.name_too_long"));
            }
            if (name.length() < 10) {
                tooltip.add((Component)Component.translatable((String)"blockprints.name_too_short"));
            }
            if (desc.length() > 1000) {
                tooltip.add((Component)Component.translatable((String)"blockprints.description_too_long"));
            }
            if (desc.length() < 20) {
                tooltip.add((Component)Component.translatable((String)"blockprints.description_too_short"));
            }
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (GuiUtils.isMouseInRelativeRange(pMouseX, pMouseY, (AbstractWidget)this.yawSlider)) {
            return this.yawSlider.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
        }
        if (GuiUtils.isMouseInRelativeRange(pMouseX, pMouseY, (AbstractWidget)this.pitchSlider)) {
            return this.pitchSlider.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_title.png"), 185, 25, 0.0f, 0.0f, 95, 14, 95, 14);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/diologue_title.png"), 185, 57, 0.0f, 0.0f, 95, 14, 95, 14);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.set_preview").getVisualOrderText(), 96, 29);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.name").getVisualOrderText(), 233, 29);
        GuiUtils.drawCenteredOutlinedText(this.font, graphics, Component.translatable((String)"blockprints.description").getVisualOrderText(), 233, 61);
    }
}

