/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.hollingsworth.schematic.client.gui;

import java.util.function.Consumer;
import neoforge.com.hollingsworth.schematic.client.gui.BaseSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class VerticalSlider
extends BaseSlider {
    Consumer<Integer> onChange;

    public VerticalSlider(int x, int y, double maxValue, double stepSize, int precision, Consumer<Integer> onChange) {
        super(x, y, 15, 140, (Component)Component.empty(), (Component)Component.empty(), 0.0, maxValue, 0.0, stepSize, precision, false);
        this.onChange = onChange;
    }

    public VerticalSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, drawString);
    }

    @Override
    protected void applyValue() {
        super.applyValue();
        this.onChange.accept(this.getValueInt());
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/container_scroll.png"), this.x, this.y - 21, 0.0f, 0.0f, 15, 159, 15, 159);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"blockprints", (String)"textures/gui/scroll_bar_vertical.png"), this.x + 3, this.y + (int)(this.value * (double)(this.height - 20)), 0.0f, 0.0f, 9, 15, 9, 15);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY != 0.0) {
            this.setValue(this.getValue() + (double)(pScrollY > 0.0 ? -1 : 1) * this.stepSize);
            this.applyValue();
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.height - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    @Override
    public void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseY - (double)(this.getY() + 4)) / (double)(this.height - 8));
    }
}

